/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializationFactory;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OFEncoder
extends MessageToByteEncoder<OfHeader> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OFEncoder.class);

    public OFEncoder() {
        LOGGER.trace("Creating OF13Encoder");
    }

    protected void encode(ChannelHandlerContext ctx, OfHeader msg, ByteBuf out) throws Exception {
        LOGGER.trace("Encoding");
        try {
            SerializationFactory.messageToBuffer(msg.getVersion(), out, msg);
        }
        catch (Exception e) {
            LOGGER.error("Message serialization failed");
            LOGGER.error(e.getMessage(), (Throwable)e);
            out.clear();
            return;
        }
        if (out.readableBytes() > 0) {
            out.retain();
            ctx.writeAndFlush((Object)out);
        } else {
            LOGGER.warn("Translated buffer is empty");
        }
    }
}

