/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.system.rev130927.SwitchIdleEventBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdleHandler
extends IdleStateHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdleHandler.class);

    public IdleHandler(long readerIdleTime, long writerIdleTime, long allIdleTime, TimeUnit unit) {
        super(readerIdleTime, writerIdleTime, allIdleTime, unit);
    }

    protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
        if (evt.state() == IdleState.READER_IDLE && evt.isFirst()) {
            LOGGER.debug("Switch idle");
            SwitchIdleEventBuilder builder = new SwitchIdleEventBuilder();
            builder.setInfo("Switch idle");
            ctx.fireChannelRead((Object)builder.build());
        }
    }
}

