/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.opendaylight.openflowjava.protocol.impl.connection.MessageConsumer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.system.rev130927.DisconnectEventBuilder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingInboundHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatingInboundHandler.class);
    protected MessageConsumer consumer;
    private boolean inactiveMessageSent = false;

    public DelegatingInboundHandler(MessageConsumer connectionAdapter) {
        LOGGER.trace("Creating DelegatingInboundHandler");
        this.consumer = connectionAdapter;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.consumer.consume((DataObject)msg);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        LOGGER.debug("Channel inactive");
        if (!this.inactiveMessageSent) {
            DisconnectEventBuilder builder = new DisconnectEventBuilder();
            builder.setInfo("Channel inactive");
            this.consumer.consume((DataObject)builder.build());
            this.inactiveMessageSent = true;
        }
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        LOGGER.debug("Channel unregistered");
        if (!this.inactiveMessageSent) {
            DisconnectEventBuilder builder = new DisconnectEventBuilder();
            builder.setInfo("Channel unregistered");
            this.consumer.consume((DataObject)builder.build());
            this.inactiveMessageSent = true;
        }
    }
}

