/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.connection;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.opendaylight.openflowjava.protocol.api.connection.ConnectionConfiguration;
import org.opendaylight.openflowjava.protocol.api.connection.SwitchConnectionHandler;
import org.opendaylight.openflowjava.protocol.impl.connection.ServerFacade;
import org.opendaylight.openflowjava.protocol.impl.core.TcpHandler;
import org.opendaylight.openflowjava.protocol.spi.connection.SwitchConnectionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchConnectionProviderImpl
implements SwitchConnectionProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwitchConnectionProviderImpl.class);
    private SwitchConnectionHandler switchConnectionHandler;
    private Set<ServerFacade> serverLot;

    public void configure(Collection<ConnectionConfiguration> connConfigs) {
        LOGGER.debug("Configuring ..");
        this.serverLot = new HashSet<ServerFacade>();
        for (ConnectionConfiguration connConfig : connConfigs) {
            TcpHandler server = new TcpHandler(connConfig.getAddress(), connConfig.getPort());
            server.setSwitchConnectionHandler(this.switchConnectionHandler);
            server.setSwitchIdleTimeout(connConfig.getSwitchIdleTimeout());
            boolean tlsSupported = ConnectionConfiguration.FEATURE_SUPPORT.REQUIRED.equals((Object)connConfig.getTlsSupport());
            server.setEncryption(tlsSupported);
            this.serverLot.add(server);
        }
    }

    public void setSwitchConnectionHandler(SwitchConnectionHandler switchConnectionHandler) {
        LOGGER.debug("setSwitchConnectionHandler");
        this.switchConnectionHandler = switchConnectionHandler;
    }

    public Future<List<Boolean>> shutdown() {
        LOGGER.debug("Shutdown summoned");
        SettableFuture result = SettableFuture.create();
        try {
            ArrayList<ListenableFuture<Boolean>> shutdownChain = new ArrayList<ListenableFuture<Boolean>>();
            for (ServerFacade server : this.serverLot) {
                ListenableFuture<Boolean> shutdownFuture = server.shutdown();
                shutdownChain.add(shutdownFuture);
            }
            if (shutdownChain.isEmpty()) {
                throw new IllegalStateException("No servers configured");
            }
            result = Futures.allAsList(shutdownChain);
        }
        catch (Exception e) {
            SettableFuture exFuture = SettableFuture.create();
            exFuture.setException((Throwable)e);
            result = exFuture;
        }
        return result;
    }

    public Future<List<Boolean>> startup() {
        LOGGER.debug("startup summoned");
        SettableFuture result = SettableFuture.create();
        try {
            if (this.serverLot.isEmpty()) {
                throw new IllegalStateException("No servers configured");
            }
            for (ServerFacade server : this.serverLot) {
                if (!server.getIsOnlineFuture().isDone()) continue;
                throw new IllegalStateException("Servers already running");
            }
            if (this.switchConnectionHandler == null) {
                throw new IllegalStateException("switchConnectionHandler is not set");
            }
            ArrayList<ListenableFuture<Boolean>> starterChain = new ArrayList<ListenableFuture<Boolean>>();
            for (ServerFacade server : this.serverLot) {
                new Thread(server).start();
                ListenableFuture<Boolean> isOnlineFuture = server.getIsOnlineFuture();
                starterChain.add(isOnlineFuture);
            }
            if (starterChain.isEmpty()) {
                throw new IllegalStateException("No servers configured");
            }
            result = Futures.allAsList(starterChain);
        }
        catch (Exception e) {
            SettableFuture exFuture = SettableFuture.create();
            exFuture.setException((Throwable)e);
            result = exFuture;
        }
        return result;
    }

    public Set<ServerFacade> getServerLot() {
        return this.serverLot;
    }
}

