/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.connection;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.SettableFuture;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.sal.common.util.RpcErrors;
import org.opendaylight.controller.sal.common.util.Rpcs;
import org.opendaylight.openflowjava.protocol.api.connection.ConnectionReadyListener;
import org.opendaylight.openflowjava.protocol.impl.connection.ConnectionFacade;
import org.opendaylight.openflowjava.protocol.impl.connection.RpcResponseKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BarrierInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BarrierOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.EchoInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.EchoOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.EchoReplyInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.EchoRequestMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ErrorMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowRemovedMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetAsyncInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetAsyncOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetConfigInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetConfigOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetQueueConfigInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetQueueConfigOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GroupModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.HelloInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.HelloMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MeterModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReplyMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OpenflowProtocolListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketInMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketOutInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortStatusMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.RoleRequestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.RoleRequestOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.SetAsyncInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.SetConfigInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.TableModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.system.rev130927.DisconnectEvent;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.system.rev130927.SwitchIdleEvent;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.system.rev130927.SystemNotificationsListener;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionAdapterImpl
implements ConnectionFacade {
    public static final int RPC_RESPONSE_EXPIRATION = 1;
    protected static final Logger LOG = LoggerFactory.getLogger(ConnectionAdapterImpl.class);
    private static final String APPLICATION_TAG = "OPENFLOW_LIBRARY";
    private static final String TAG = "OPENFLOW";
    private Channel channel;
    private OpenflowProtocolListener messageListener;
    protected Cache<RpcResponseKey, SettableFuture<?>> responseCache = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterWrite(1L, TimeUnit.MINUTES).removalListener((RemovalListener)new ResponseRemovalListener()).build();
    private SystemNotificationsListener systemListener;
    private boolean disconnectOccured = false;
    protected ConnectionReadyListener connectionReadyListener;

    public ConnectionAdapterImpl() {
        LOG.debug("ConnectionAdapter created");
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public java.util.concurrent.Future<RpcResult<BarrierOutput>> barrier(BarrierInput input) {
        return this.sendToSwitchExpectRpcResultFuture(input, BarrierOutput.class, "barrier-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<EchoOutput>> echo(EchoInput input) {
        return this.sendToSwitchExpectRpcResultFuture(input, EchoOutput.class, "echo-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<Void>> echoReply(EchoReplyInput input) {
        return this.sendToSwitchFuture((DataObject)input, "echo-reply sending failed");
    }

    public java.util.concurrent.Future<RpcResult<Void>> experimenter(ExperimenterInput input) {
        return this.sendToSwitchFuture((DataObject)input, "experimenter sending failed");
    }

    public java.util.concurrent.Future<RpcResult<Void>> flowMod(FlowModInput input) {
        return this.sendToSwitchFuture((DataObject)input, "flow-mod sending failed");
    }

    public java.util.concurrent.Future<RpcResult<GetConfigOutput>> getConfig(GetConfigInput input) {
        return this.sendToSwitchExpectRpcResultFuture(input, GetConfigOutput.class, "get-config-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<GetFeaturesOutput>> getFeatures(GetFeaturesInput input) {
        return this.sendToSwitchExpectRpcResultFuture(input, GetFeaturesOutput.class, "get-features-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<GetQueueConfigOutput>> getQueueConfig(GetQueueConfigInput input) {
        return this.sendToSwitchExpectRpcResultFuture(input, GetQueueConfigOutput.class, "get-queue-config-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<Void>> groupMod(GroupModInput input) {
        return this.sendToSwitchFuture((DataObject)input, "group-mod-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<Void>> hello(HelloInput input) {
        return this.sendToSwitchFuture((DataObject)input, "hello-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<Void>> meterMod(MeterModInput input) {
        return this.sendToSwitchFuture((DataObject)input, "meter-mod-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<Void>> packetOut(PacketOutInput input) {
        return this.sendToSwitchFuture((DataObject)input, "packet-out-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<Void>> multipartRequest(MultipartRequestInput input) {
        return this.sendToSwitchFuture((DataObject)input, "multi-part-request sending failed");
    }

    public java.util.concurrent.Future<RpcResult<Void>> portMod(PortModInput input) {
        return this.sendToSwitchFuture((DataObject)input, "port-mod-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<RoleRequestOutput>> roleRequest(RoleRequestInput input) {
        return this.sendToSwitchExpectRpcResultFuture(input, RoleRequestOutput.class, "role-request-config-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<Void>> setConfig(SetConfigInput input) {
        return this.sendToSwitchFuture((DataObject)input, "set-config-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<Void>> tableMod(TableModInput input) {
        return this.sendToSwitchFuture((DataObject)input, "table-mod-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<GetAsyncOutput>> getAsync(GetAsyncInput input) {
        return this.sendToSwitchExpectRpcResultFuture(input, GetAsyncOutput.class, "get-async-input sending failed");
    }

    public java.util.concurrent.Future<RpcResult<Void>> setAsync(SetAsyncInput input) {
        return this.sendToSwitchFuture((DataObject)input, "set-async-input sending failed");
    }

    public java.util.concurrent.Future<Boolean> disconnect() {
        ChannelFuture disconnectResult = this.channel.disconnect();
        this.responseCache.invalidateAll();
        this.disconnectOccured = true;
        String failureInfo = "switch disconnecting failed";
        RpcError.ErrorSeverity errorSeverity = RpcError.ErrorSeverity.ERROR;
        String message = "Check the switch connection";
        return ConnectionAdapterImpl.handleTransportChannelFuture(disconnectResult, failureInfo, errorSeverity, message);
    }

    public boolean isAlive() {
        return this.channel.isOpen();
    }

    public void setMessageListener(OpenflowProtocolListener messageListener) {
        this.messageListener = messageListener;
    }

    @Override
    public void consume(DataObject message) {
        LOG.debug("ConsumeIntern msg");
        if (this.disconnectOccured) {
            return;
        }
        if (message instanceof Notification) {
            if (message instanceof DisconnectEvent) {
                this.systemListener.onDisconnectEvent((DisconnectEvent)message);
                this.responseCache.invalidateAll();
                this.disconnectOccured = true;
            } else if (message instanceof SwitchIdleEvent) {
                this.systemListener.onSwitchIdleEvent((SwitchIdleEvent)message);
            } else if (message instanceof EchoRequestMessage) {
                this.messageListener.onEchoRequestMessage((EchoRequestMessage)message);
            } else if (message instanceof ErrorMessage) {
                this.messageListener.onErrorMessage((ErrorMessage)message);
            } else if (message instanceof ExperimenterMessage) {
                this.messageListener.onExperimenterMessage((ExperimenterMessage)message);
            } else if (message instanceof FlowRemovedMessage) {
                this.messageListener.onFlowRemovedMessage((FlowRemovedMessage)message);
            } else if (message instanceof HelloMessage) {
                LOG.info("Hello received / branch");
                this.messageListener.onHelloMessage((HelloMessage)message);
            } else if (message instanceof MultipartReplyMessage) {
                this.messageListener.onMultipartReplyMessage((MultipartReplyMessage)message);
            } else if (message instanceof PacketInMessage) {
                this.messageListener.onPacketInMessage((PacketInMessage)message);
            } else if (message instanceof PortStatusMessage) {
                this.messageListener.onPortStatusMessage((PortStatusMessage)message);
            } else {
                LOG.warn("message listening not supported for type: " + message.getClass());
            }
        } else if (message instanceof OfHeader) {
            LOG.debug("OFheader msg received");
            RpcResponseKey key = ConnectionAdapterImpl.createRpcResponseKey((OfHeader)message);
            SettableFuture<RpcResult<?>> rpcFuture = this.findRpcResponse(key);
            if (rpcFuture != null) {
                LOG.debug("corresponding rpcFuture found");
                List errors = Collections.emptyList();
                LOG.debug("before setting rpcFuture");
                rpcFuture.set((Object)Rpcs.getRpcResult((boolean)true, (Object)message, errors));
                LOG.debug("after setting rpcFuture");
                this.responseCache.invalidate((Object)key);
            } else {
                LOG.warn("received unexpected rpc response: " + key);
            }
        } else {
            LOG.warn("message listening not supported for type: " + message.getClass());
        }
    }

    private SettableFuture<RpcResult<Void>> sendToSwitchFuture(DataObject input, String failureInfo) {
        LOG.debug("going to flush");
        ChannelFuture resultFuture = this.channel.writeAndFlush((Object)input);
        LOG.debug("flushed");
        RpcError.ErrorSeverity errorSeverity = RpcError.ErrorSeverity.ERROR;
        String errorMessage = "check switch connection";
        return this.handleRpcChannelFuture(resultFuture, failureInfo, errorSeverity, errorMessage);
    }

    private <IN extends OfHeader, OUT extends OfHeader> SettableFuture<RpcResult<OUT>> sendToSwitchExpectRpcResultFuture(IN input, Class<OUT> responseClazz, String failureInfo) {
        LOG.debug("going to flush");
        SettableFuture rpcResult = SettableFuture.create();
        RpcResponseKey key = new RpcResponseKey(input.getXid(), responseClazz.getName());
        this.responseCache.put((Object)key, (Object)rpcResult);
        ChannelFuture resultFuture = this.channel.writeAndFlush(input);
        LOG.debug("flushed");
        RpcError.ErrorSeverity errorSeverity = RpcError.ErrorSeverity.ERROR;
        String errorMessage = "check switch connection";
        return this.handleRpcChannelFutureWithResponse(resultFuture, failureInfo, errorSeverity, errorMessage, input, responseClazz, rpcResult, key);
    }

    private SettableFuture<RpcResult<Void>> handleRpcChannelFuture(ChannelFuture resultFuture, final String failureInfo, final RpcError.ErrorSeverity errorSeverity, final String errorMessage) {
        final SettableFuture rpcResult = SettableFuture.create();
        LOG.debug("handlerpcchannelfuture");
        resultFuture.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

            public void operationComplete(Future<? super Void> future) throws Exception {
                LOG.debug("operation complete");
                ArrayList errors = Collections.emptyList();
                if (future.cause() != null) {
                    LOG.debug("future.cause != null");
                    RpcError rpcError = ConnectionAdapterImpl.this.buildRpcError(failureInfo, errorSeverity, errorMessage, future.cause());
                    errors = Lists.newArrayList((Object[])new RpcError[]{rpcError});
                }
                rpcResult.set((Object)Rpcs.getRpcResult((boolean)future.isSuccess(), (Object)null, errors));
            }
        });
        return rpcResult;
    }

    private <IN extends OfHeader, OUT extends OfHeader> SettableFuture<RpcResult<OUT>> handleRpcChannelFutureWithResponse(ChannelFuture resultFuture, final String failureInfo, final RpcError.ErrorSeverity errorSeverity, final String errorMessage, IN input, Class<OUT> responseClazz, final SettableFuture<RpcResult<OUT>> rpcResult, final RpcResponseKey key) {
        LOG.debug("handleRpcchanfuture with response");
        resultFuture.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

            public void operationComplete(Future<? super Void> future) throws Exception {
                LOG.debug("operation complete");
                ArrayList errors = Collections.emptyList();
                if (future.cause() != null) {
                    LOG.debug("ChannelFuture.cause != null");
                    RpcError rpcError = ConnectionAdapterImpl.this.buildRpcError(failureInfo, errorSeverity, errorMessage, future.cause());
                    errors = Lists.newArrayList((Object[])new RpcError[]{rpcError});
                    rpcResult.set((Object)Rpcs.getRpcResult((boolean)future.isSuccess(), (Object)null, (Collection)errors));
                    ConnectionAdapterImpl.this.responseCache.invalidate((Object)key);
                } else {
                    LOG.debug("ChannelFuture.cause == null");
                    if (ConnectionAdapterImpl.this.responseCache.getIfPresent((Object)key) == null) {
                        LOG.debug("responcache: key wasn't present");
                    }
                }
            }
        });
        return rpcResult;
    }

    private static SettableFuture<Boolean> handleTransportChannelFuture(ChannelFuture resultFuture, String failureInfo, RpcError.ErrorSeverity errorSeverity, String message) {
        final SettableFuture transportResult = SettableFuture.create();
        resultFuture.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

            public void operationComplete(Future<? super Void> future) throws Exception {
                transportResult.set((Object)future.isSuccess());
                if (!future.isSuccess()) {
                    transportResult.setException(future.cause());
                }
            }
        });
        return transportResult;
    }

    protected RpcError buildRpcError(String info, RpcError.ErrorSeverity severity, String message, Throwable cause) {
        RpcError error = RpcErrors.getRpcError((String)APPLICATION_TAG, (String)TAG, (String)info, (RpcError.ErrorSeverity)severity, (String)message, (RpcError.ErrorType)RpcError.ErrorType.RPC, (Throwable)cause);
        return error;
    }

    protected RpcError buildTransportError(String info, RpcError.ErrorSeverity severity, String message, Throwable cause) {
        RpcError error = RpcErrors.getRpcError((String)APPLICATION_TAG, (String)TAG, (String)info, (RpcError.ErrorSeverity)severity, (String)message, (RpcError.ErrorType)RpcError.ErrorType.TRANSPORT, (Throwable)cause);
        return error;
    }

    private static RpcResponseKey createRpcResponseKey(OfHeader message) {
        return new RpcResponseKey(message.getXid(), message.getImplementedInterface().getName());
    }

    private SettableFuture<RpcResult<?>> findRpcResponse(RpcResponseKey key) {
        return (SettableFuture)this.responseCache.getIfPresent((Object)key);
    }

    public void setSystemListener(SystemNotificationsListener systemListener) {
        this.systemListener = systemListener;
    }

    public void checkListeners() {
        StringBuffer buffer = new StringBuffer();
        if (this.systemListener == null) {
            buffer.append("SystemListener ");
        }
        if (this.messageListener == null) {
            buffer.append("MessageListener ");
        }
        if (this.connectionReadyListener == null) {
            buffer.append("ConnectionReadyListener ");
        }
        if (buffer.length() > 0) {
            throw new IllegalStateException("Missing listeners: " + buffer.toString());
        }
    }

    public void fireConnectionReadyNotification() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ConnectionAdapterImpl.this.connectionReadyListener.onConnectionReady();
            }
        }).start();
    }

    public void setConnectionReadyListener(ConnectionReadyListener connectionReadyListener) {
        this.connectionReadyListener = connectionReadyListener;
    }

    static class ExitingDataObject
    implements DataObject {
        ExitingDataObject() {
        }

        public Class<? extends DataContainer> getImplementedInterface() {
            return null;
        }
    }

    static class ResponseRemovalListener
    implements RemovalListener<RpcResponseKey, SettableFuture<?>> {
        ResponseRemovalListener() {
        }

        public void onRemoval(RemovalNotification<RpcResponseKey, SettableFuture<?>> notification) {
            SettableFuture future = (SettableFuture)notification.getValue();
            if (!future.isDone()) {
                LOG.warn("rpc response discarded: " + notification.getKey());
                future.cancel(true);
            }
        }
    }
}

