/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.shutdown.impl;

import com.google.common.base.Optional;
import org.opendaylight.controller.config.shutdown.ShutdownService;
import org.opendaylight.controller.config.yang.shutdown.impl.CallSystemExitThread;
import org.opendaylight.controller.config.yang.shutdown.impl.StopSystemBundleThread;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Impl
implements ShutdownService {
    private static final Logger logger = LoggerFactory.getLogger(Impl.class);
    private final String secret;
    private final Bundle systemBundle;

    Impl(String secret, Bundle systemBundle) {
        this.secret = secret;
        this.systemBundle = systemBundle;
    }

    public void shutdown(String inputSecret, Long maxWaitTime, Optional<String> reason) {
        logger.warn("Shutdown issued with secret {} and reason {}", (Object)inputSecret, reason);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("Shutdown process interrupted", (Throwable)e);
        }
        if (this.secret.equals(inputSecret)) {
            logger.info("Server is shutting down");
            StopSystemBundleThread stopSystemBundleThread = new StopSystemBundleThread(this.systemBundle);
            stopSystemBundleThread.start();
            if (maxWaitTime != null && maxWaitTime > 0L) {
                CallSystemExitThread systemExitThread = new CallSystemExitThread(maxWaitTime);
                logger.debug("Scheduling {}", (Object)systemExitThread);
                systemExitThread.start();
            }
        } else {
            logger.warn("Unauthorized attempt to shut down server");
            throw new IllegalArgumentException("Invalid secret");
        }
    }
}

