/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.shutdown.impl;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CallSystemExitThread
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(CallSystemExitThread.class);
    private final long maxWaitTime;

    CallSystemExitThread(long maxWaitTime) {
        super("call-system-exit-daemon");
        this.setDaemon(true);
        if (maxWaitTime <= 0L) {
            throw new IllegalArgumentException("Cannot schedule to zero or negative time:" + maxWaitTime);
        }
        this.maxWaitTime = maxWaitTime;
    }

    @Override
    public String toString() {
        return "CallSystemExitThread{maxWaitTime=" + this.maxWaitTime + '}';
    }

    @Override
    public void run() {
        try {
            Thread.sleep(this.maxWaitTime);
            logger.error("Since some threads are still running, server is going to shut down via System.exit(1) !");
            ThreadInfo[] threads = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true);
            StringBuffer sb = new StringBuffer();
            for (ThreadInfo info : threads) {
                sb.append(info);
                sb.append("\n");
            }
            logger.warn("Thread dump:{}", (Object)sb);
            System.exit(1);
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted, not going to call System.exit(1)");
        }
    }
}

