/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.shutdown.impl;

import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.RuntimeBeanRegistratorAwareModule;
import org.opendaylight.controller.config.api.runtime.RootRuntimeBeanRegistrator;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.yang.shutdown.ShutdownServiceServiceInterface;
import org.opendaylight.controller.config.yang.shutdown.impl.ShutdownModuleMXBean;
import org.opendaylight.controller.config.yang.shutdown.impl.ShutdownRuntimeRegistrator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractShutdownModule
implements Module,
ShutdownModuleMXBean,
ShutdownServiceServiceInterface,
RuntimeBeanRegistratorAwareModule {
    protected final JmxAttribute secretJmxAttribute = new JmxAttribute("Secret");
    private String secret = "";
    private static final Logger logger = LoggerFactory.getLogger(AbstractShutdownModule.class);
    private final AbstractShutdownModule oldModule;
    private final AutoCloseable oldInstance;
    private AutoCloseable instance;
    private final DependencyResolver dependencyResolver;
    private final ModuleIdentifier identifier;
    private ShutdownRuntimeRegistrator rootRuntimeBeanRegistratorWrapper;

    public AbstractShutdownModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldInstance = null;
        this.oldModule = null;
    }

    public AbstractShutdownModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractShutdownModule oldModule, AutoCloseable oldInstance) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldInstance = oldInstance;
        this.oldModule = oldModule;
    }

    @Override
    public String getSecret() {
        return this.secret;
    }

    @Override
    public void setSecret(String secret) {
        this.secret = secret;
    }

    public ShutdownRuntimeRegistrator getRootRuntimeBeanRegistratorWrapper() {
        return this.rootRuntimeBeanRegistratorWrapper;
    }

    public void setRuntimeBeanRegistrator(RootRuntimeBeanRegistrator rootRuntimeRegistrator) {
        this.rootRuntimeBeanRegistratorWrapper = new ShutdownRuntimeRegistrator(rootRuntimeRegistrator);
    }

    public void validate() {
        this.customValidation();
    }

    protected void customValidation() {
    }

    public final AutoCloseable getInstance() {
        if (this.instance == null) {
            if (this.oldInstance != null && this.canReuseInstance(this.oldModule)) {
                this.instance = this.reuseInstance(this.oldInstance);
            } else {
                if (this.oldInstance != null) {
                    try {
                        this.oldInstance.close();
                    }
                    catch (Exception e) {
                        logger.error("An error occurred while closing old instance " + this.oldInstance, (Throwable)e);
                    }
                }
                this.instance = this.createInstance();
            }
        }
        return this.instance;
    }

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    public boolean canReuseInstance(AbstractShutdownModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public abstract AutoCloseable createInstance();

    public boolean isSame(AbstractShutdownModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        return !(this.secret == null ? other.secret != null : !this.secret.equals(other.secret));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractShutdownModule that = (AbstractShutdownModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }
}

