/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.property.header;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.QueueProperties;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.property.header.QueueProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.property.header.QueuePropertyKey;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class QueuePropertyBuilder {
    private QueueProperties _property;
    private QueuePropertyKey _key;
    private Map<Class<? extends Augmentation<QueueProperty>>, Augmentation<QueueProperty>> augmentation = new HashMap<Class<? extends Augmentation<QueueProperty>>, Augmentation<QueueProperty>>();

    public QueueProperties getProperty() {
        return this._property;
    }

    public QueuePropertyKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<QueueProperty>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public QueuePropertyBuilder setProperty(QueueProperties value) {
        this._property = value;
        return this;
    }

    public QueuePropertyBuilder setKey(QueuePropertyKey value) {
        this._key = value;
        return this;
    }

    public QueuePropertyBuilder addAugmentation(Class<? extends Augmentation<QueueProperty>> augmentationType, Augmentation<QueueProperty> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public QueueProperty build() {
        return new QueuePropertyImpl(this);
    }

    private static final class QueuePropertyImpl
    implements QueueProperty {
        private final QueueProperties _property;
        private final QueuePropertyKey _key;
        private Map<Class<? extends Augmentation<QueueProperty>>, Augmentation<QueueProperty>> augmentation = new HashMap<Class<? extends Augmentation<QueueProperty>>, Augmentation<QueueProperty>>();

        public Class<QueueProperty> getImplementedInterface() {
            return QueueProperty.class;
        }

        private QueuePropertyImpl(QueuePropertyBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new QueuePropertyKey(builder.getProperty());
                this._property = builder.getProperty();
            } else {
                this._key = builder.getKey();
                this._property = this._key.getProperty();
            }
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public QueueProperties getProperty() {
            return this._property;
        }

        @Override
        public QueuePropertyKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<QueueProperty>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._property == null ? 0 : this._property.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QueuePropertyImpl other = (QueuePropertyImpl)obj;
            if (this._property == null ? other._property != null : !this._property.equals((Object)other._property)) {
                return false;
            }
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("QueueProperty [_property=");
            builder.append((Object)this._property);
            builder.append(", _key=");
            builder.append(this._key);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

