/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.get.config.reply;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.QueueId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketQueue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.QueuePropertyHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.get.config.reply.Queues;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.property.header.QueueProperty;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class QueuesBuilder {
    private PortNumber _port;
    private QueueId _queueId;
    private List<QueueProperty> _queueProperty;
    private Map<Class<? extends Augmentation<Queues>>, Augmentation<Queues>> augmentation = new HashMap<Class<? extends Augmentation<Queues>>, Augmentation<Queues>>();

    public QueuesBuilder() {
    }

    public QueuesBuilder(PacketQueue arg) {
        this._port = arg.getPort();
        this._queueId = arg.getQueueId();
        this._queueProperty = arg.getQueueProperty();
    }

    public QueuesBuilder(QueuePropertyHeader arg) {
        this._queueProperty = arg.getQueueProperty();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PacketQueue) {
            this._port = ((PacketQueue)arg).getPort();
            this._queueId = ((PacketQueue)arg).getQueueId();
            isValidArg = true;
        }
        if (arg instanceof QueuePropertyHeader) {
            this._queueProperty = ((QueuePropertyHeader)arg).getQueueProperty();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketQueue, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.QueuePropertyHeader] \nbut was: " + arg);
        }
    }

    public PortNumber getPort() {
        return this._port;
    }

    public QueueId getQueueId() {
        return this._queueId;
    }

    public List<QueueProperty> getQueueProperty() {
        return this._queueProperty;
    }

    public <E extends Augmentation<Queues>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public QueuesBuilder setPort(PortNumber value) {
        this._port = value;
        return this;
    }

    public QueuesBuilder setQueueId(QueueId value) {
        this._queueId = value;
        return this;
    }

    public QueuesBuilder setQueueProperty(List<QueueProperty> value) {
        this._queueProperty = value;
        return this;
    }

    public QueuesBuilder addAugmentation(Class<? extends Augmentation<Queues>> augmentationType, Augmentation<Queues> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Queues build() {
        return new QueuesImpl(this);
    }

    private static final class QueuesImpl
    implements Queues {
        private final PortNumber _port;
        private final QueueId _queueId;
        private final List<QueueProperty> _queueProperty;
        private Map<Class<? extends Augmentation<Queues>>, Augmentation<Queues>> augmentation = new HashMap<Class<? extends Augmentation<Queues>>, Augmentation<Queues>>();

        public Class<Queues> getImplementedInterface() {
            return Queues.class;
        }

        private QueuesImpl(QueuesBuilder builder) {
            this._port = builder.getPort();
            this._queueId = builder.getQueueId();
            this._queueProperty = builder.getQueueProperty();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public PortNumber getPort() {
            return this._port;
        }

        @Override
        public QueueId getQueueId() {
            return this._queueId;
        }

        @Override
        public List<QueueProperty> getQueueProperty() {
            return this._queueProperty;
        }

        public <E extends Augmentation<Queues>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._port == null ? 0 : this._port.hashCode());
            result = 31 * result + (this._queueId == null ? 0 : this._queueId.hashCode());
            result = 31 * result + (this._queueProperty == null ? 0 : this._queueProperty.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QueuesImpl other = (QueuesImpl)obj;
            if (this._port == null ? other._port != null : !this._port.equals(other._port)) {
                return false;
            }
            if (this._queueId == null ? other._queueId != null : !this._queueId.equals(other._queueId)) {
                return false;
            }
            if (this._queueProperty == null ? other._queueProperty != null : !this._queueProperty.equals(other._queueProperty)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Queues [_port=");
            builder.append(this._port);
            builder.append(", _queueId=");
            builder.append(this._queueId);
            builder.append(", _queueProperty=");
            builder.append(this._queueProperty);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

