/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.queue._case;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.queue._case.MultipartRequestQueue;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class MultipartRequestQueueBuilder {
    private Long _portNo;
    private Long _queueId;
    private Map<Class<? extends Augmentation<MultipartRequestQueue>>, Augmentation<MultipartRequestQueue>> augmentation = new HashMap<Class<? extends Augmentation<MultipartRequestQueue>>, Augmentation<MultipartRequestQueue>>();

    public Long getPortNo() {
        return this._portNo;
    }

    public Long getQueueId() {
        return this._queueId;
    }

    public <E extends Augmentation<MultipartRequestQueue>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MultipartRequestQueueBuilder setPortNo(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._portNo = value;
        return this;
    }

    public MultipartRequestQueueBuilder setQueueId(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._queueId = value;
        return this;
    }

    public MultipartRequestQueueBuilder addAugmentation(Class<? extends Augmentation<MultipartRequestQueue>> augmentationType, Augmentation<MultipartRequestQueue> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MultipartRequestQueue build() {
        return new MultipartRequestQueueImpl(this);
    }

    private static final class MultipartRequestQueueImpl
    implements MultipartRequestQueue {
        private final Long _portNo;
        private final Long _queueId;
        private Map<Class<? extends Augmentation<MultipartRequestQueue>>, Augmentation<MultipartRequestQueue>> augmentation = new HashMap<Class<? extends Augmentation<MultipartRequestQueue>>, Augmentation<MultipartRequestQueue>>();

        public Class<MultipartRequestQueue> getImplementedInterface() {
            return MultipartRequestQueue.class;
        }

        private MultipartRequestQueueImpl(MultipartRequestQueueBuilder builder) {
            this._portNo = builder.getPortNo();
            this._queueId = builder.getQueueId();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Long getPortNo() {
            return this._portNo;
        }

        @Override
        public Long getQueueId() {
            return this._queueId;
        }

        public <E extends Augmentation<MultipartRequestQueue>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._portNo == null ? 0 : this._portNo.hashCode());
            result = 31 * result + (this._queueId == null ? 0 : this._queueId.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MultipartRequestQueueImpl other = (MultipartRequestQueueImpl)obj;
            if (this._portNo == null ? other._portNo != null : !this._portNo.equals(other._portNo)) {
                return false;
            }
            if (this._queueId == null ? other._queueId != null : !this._queueId.equals(other._queueId)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MultipartRequestQueue [_portNo=");
            builder.append(this._portNo);
            builder.append(", _queueId=");
            builder.append(this._queueId);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

