/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table.features._case.multipart.reply.table.features;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.TableFeaturesProperties;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table.features._case.multipart.reply.table.features.TableFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.table.features.properties.TableFeatureProperties;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TableFeaturesBuilder {
    private TableConfig _config;
    private Long _maxEntries;
    private byte[] _metadataMatch;
    private byte[] _metadataWrite;
    private String _name;
    private Short _tableId;
    private List<TableFeatureProperties> _tableFeatureProperties;
    private Map<Class<? extends Augmentation<TableFeatures>>, Augmentation<TableFeatures>> augmentation = new HashMap<Class<? extends Augmentation<TableFeatures>>, Augmentation<TableFeatures>>();

    public TableFeaturesBuilder() {
    }

    public TableFeaturesBuilder(TableFeaturesProperties arg) {
        this._tableFeatureProperties = arg.getTableFeatureProperties();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof TableFeaturesProperties) {
            this._tableFeatureProperties = ((TableFeaturesProperties)arg).getTableFeatureProperties();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.TableFeaturesProperties] \nbut was: " + arg);
        }
    }

    public TableConfig getConfig() {
        return this._config;
    }

    public Long getMaxEntries() {
        return this._maxEntries;
    }

    public byte[] getMetadataMatch() {
        return this._metadataMatch;
    }

    public byte[] getMetadataWrite() {
        return this._metadataWrite;
    }

    public String getName() {
        return this._name;
    }

    public Short getTableId() {
        return this._tableId;
    }

    public List<TableFeatureProperties> getTableFeatureProperties() {
        return this._tableFeatureProperties;
    }

    public <E extends Augmentation<TableFeatures>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public TableFeaturesBuilder setConfig(TableConfig value) {
        this._config = value;
        return this;
    }

    public TableFeaturesBuilder setMaxEntries(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._maxEntries = value;
        return this;
    }

    public TableFeaturesBuilder setMetadataMatch(byte[] value) {
        this._metadataMatch = value;
        return this;
    }

    public TableFeaturesBuilder setMetadataWrite(byte[] value) {
        this._metadataWrite = value;
        return this;
    }

    public TableFeaturesBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public TableFeaturesBuilder setTableId(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._tableId = value;
        return this;
    }

    public TableFeaturesBuilder setTableFeatureProperties(List<TableFeatureProperties> value) {
        this._tableFeatureProperties = value;
        return this;
    }

    public TableFeaturesBuilder addAugmentation(Class<? extends Augmentation<TableFeatures>> augmentationType, Augmentation<TableFeatures> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public TableFeatures build() {
        return new TableFeaturesImpl(this);
    }

    private static final class TableFeaturesImpl
    implements TableFeatures {
        private final TableConfig _config;
        private final Long _maxEntries;
        private final byte[] _metadataMatch;
        private final byte[] _metadataWrite;
        private final String _name;
        private final Short _tableId;
        private final List<TableFeatureProperties> _tableFeatureProperties;
        private Map<Class<? extends Augmentation<TableFeatures>>, Augmentation<TableFeatures>> augmentation = new HashMap<Class<? extends Augmentation<TableFeatures>>, Augmentation<TableFeatures>>();

        public Class<TableFeatures> getImplementedInterface() {
            return TableFeatures.class;
        }

        private TableFeaturesImpl(TableFeaturesBuilder builder) {
            this._config = builder.getConfig();
            this._maxEntries = builder.getMaxEntries();
            this._metadataMatch = builder.getMetadataMatch();
            this._metadataWrite = builder.getMetadataWrite();
            this._name = builder.getName();
            this._tableId = builder.getTableId();
            this._tableFeatureProperties = builder.getTableFeatureProperties();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public TableConfig getConfig() {
            return this._config;
        }

        @Override
        public Long getMaxEntries() {
            return this._maxEntries;
        }

        @Override
        public byte[] getMetadataMatch() {
            return this._metadataMatch;
        }

        @Override
        public byte[] getMetadataWrite() {
            return this._metadataWrite;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public Short getTableId() {
            return this._tableId;
        }

        @Override
        public List<TableFeatureProperties> getTableFeatureProperties() {
            return this._tableFeatureProperties;
        }

        public <E extends Augmentation<TableFeatures>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._config == null ? 0 : this._config.hashCode());
            result = 31 * result + (this._maxEntries == null ? 0 : this._maxEntries.hashCode());
            result = 31 * result + (this._metadataMatch == null ? 0 : Arrays.hashCode(this._metadataMatch));
            result = 31 * result + (this._metadataWrite == null ? 0 : Arrays.hashCode(this._metadataWrite));
            result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
            result = 31 * result + (this._tableId == null ? 0 : this._tableId.hashCode());
            result = 31 * result + (this._tableFeatureProperties == null ? 0 : this._tableFeatureProperties.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TableFeaturesImpl other = (TableFeaturesImpl)obj;
            if (this._config == null ? other._config != null : !this._config.equals(other._config)) {
                return false;
            }
            if (this._maxEntries == null ? other._maxEntries != null : !this._maxEntries.equals(other._maxEntries)) {
                return false;
            }
            if (this._metadataMatch == null ? other._metadataMatch != null : !Arrays.equals(this._metadataMatch, other._metadataMatch)) {
                return false;
            }
            if (this._metadataWrite == null ? other._metadataWrite != null : !Arrays.equals(this._metadataWrite, other._metadataWrite)) {
                return false;
            }
            if (this._name == null ? other._name != null : !this._name.equals(other._name)) {
                return false;
            }
            if (this._tableId == null ? other._tableId != null : !this._tableId.equals(other._tableId)) {
                return false;
            }
            if (this._tableFeatureProperties == null ? other._tableFeatureProperties != null : !this._tableFeatureProperties.equals(other._tableFeatureProperties)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("TableFeatures [_config=");
            builder.append(this._config);
            builder.append(", _maxEntries=");
            builder.append(this._maxEntries);
            builder.append(", _metadataMatch=");
            builder.append(Arrays.toString(this._metadataMatch));
            builder.append(", _metadataWrite=");
            builder.append(Arrays.toString(this._metadataWrite));
            builder.append(", _name=");
            builder.append(this._name);
            builder.append(", _tableId=");
            builder.append(this._tableId);
            builder.append(", _tableFeatureProperties=");
            builder.append(this._tableFeatureProperties);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

