/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table._case.multipart.reply.table;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowWildcardsV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table._case.multipart.reply.table.TableStats;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class TableStatsBuilder {
    private Long _activeCount;
    private BigInteger _lookupCount;
    private BigInteger _matchedCount;
    private Long _maxEntries;
    private String _name;
    private Short _nwDstMask;
    private Short _nwSrcMask;
    private Short _tableId;
    private FlowWildcardsV10 _wildcards;
    private Map<Class<? extends Augmentation<TableStats>>, Augmentation<TableStats>> augmentation = new HashMap<Class<? extends Augmentation<TableStats>>, Augmentation<TableStats>>();

    public Long getActiveCount() {
        return this._activeCount;
    }

    public BigInteger getLookupCount() {
        return this._lookupCount;
    }

    public BigInteger getMatchedCount() {
        return this._matchedCount;
    }

    public Long getMaxEntries() {
        return this._maxEntries;
    }

    public String getName() {
        return this._name;
    }

    public Short getNwDstMask() {
        return this._nwDstMask;
    }

    public Short getNwSrcMask() {
        return this._nwSrcMask;
    }

    public Short getTableId() {
        return this._tableId;
    }

    public FlowWildcardsV10 getWildcards() {
        return this._wildcards;
    }

    public <E extends Augmentation<TableStats>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public TableStatsBuilder setActiveCount(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._activeCount = value;
        return this;
    }

    public TableStatsBuilder setLookupCount(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._lookupCount = value;
        return this;
    }

    public TableStatsBuilder setMatchedCount(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._matchedCount = value;
        return this;
    }

    public TableStatsBuilder setMaxEntries(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._maxEntries = value;
        return this;
    }

    public TableStatsBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public TableStatsBuilder setNwDstMask(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._nwDstMask = value;
        return this;
    }

    public TableStatsBuilder setNwSrcMask(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._nwSrcMask = value;
        return this;
    }

    public TableStatsBuilder setTableId(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._tableId = value;
        return this;
    }

    public TableStatsBuilder setWildcards(FlowWildcardsV10 value) {
        this._wildcards = value;
        return this;
    }

    public TableStatsBuilder addAugmentation(Class<? extends Augmentation<TableStats>> augmentationType, Augmentation<TableStats> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public TableStats build() {
        return new TableStatsImpl(this);
    }

    private static final class TableStatsImpl
    implements TableStats {
        private final Long _activeCount;
        private final BigInteger _lookupCount;
        private final BigInteger _matchedCount;
        private final Long _maxEntries;
        private final String _name;
        private final Short _nwDstMask;
        private final Short _nwSrcMask;
        private final Short _tableId;
        private final FlowWildcardsV10 _wildcards;
        private Map<Class<? extends Augmentation<TableStats>>, Augmentation<TableStats>> augmentation = new HashMap<Class<? extends Augmentation<TableStats>>, Augmentation<TableStats>>();

        public Class<TableStats> getImplementedInterface() {
            return TableStats.class;
        }

        private TableStatsImpl(TableStatsBuilder builder) {
            this._activeCount = builder.getActiveCount();
            this._lookupCount = builder.getLookupCount();
            this._matchedCount = builder.getMatchedCount();
            this._maxEntries = builder.getMaxEntries();
            this._name = builder.getName();
            this._nwDstMask = builder.getNwDstMask();
            this._nwSrcMask = builder.getNwSrcMask();
            this._tableId = builder.getTableId();
            this._wildcards = builder.getWildcards();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Long getActiveCount() {
            return this._activeCount;
        }

        @Override
        public BigInteger getLookupCount() {
            return this._lookupCount;
        }

        @Override
        public BigInteger getMatchedCount() {
            return this._matchedCount;
        }

        @Override
        public Long getMaxEntries() {
            return this._maxEntries;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public Short getNwDstMask() {
            return this._nwDstMask;
        }

        @Override
        public Short getNwSrcMask() {
            return this._nwSrcMask;
        }

        @Override
        public Short getTableId() {
            return this._tableId;
        }

        @Override
        public FlowWildcardsV10 getWildcards() {
            return this._wildcards;
        }

        public <E extends Augmentation<TableStats>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._activeCount == null ? 0 : this._activeCount.hashCode());
            result = 31 * result + (this._lookupCount == null ? 0 : this._lookupCount.hashCode());
            result = 31 * result + (this._matchedCount == null ? 0 : this._matchedCount.hashCode());
            result = 31 * result + (this._maxEntries == null ? 0 : this._maxEntries.hashCode());
            result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
            result = 31 * result + (this._nwDstMask == null ? 0 : this._nwDstMask.hashCode());
            result = 31 * result + (this._nwSrcMask == null ? 0 : this._nwSrcMask.hashCode());
            result = 31 * result + (this._tableId == null ? 0 : this._tableId.hashCode());
            result = 31 * result + (this._wildcards == null ? 0 : this._wildcards.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TableStatsImpl other = (TableStatsImpl)obj;
            if (this._activeCount == null ? other._activeCount != null : !this._activeCount.equals(other._activeCount)) {
                return false;
            }
            if (this._lookupCount == null ? other._lookupCount != null : !this._lookupCount.equals(other._lookupCount)) {
                return false;
            }
            if (this._matchedCount == null ? other._matchedCount != null : !this._matchedCount.equals(other._matchedCount)) {
                return false;
            }
            if (this._maxEntries == null ? other._maxEntries != null : !this._maxEntries.equals(other._maxEntries)) {
                return false;
            }
            if (this._name == null ? other._name != null : !this._name.equals(other._name)) {
                return false;
            }
            if (this._nwDstMask == null ? other._nwDstMask != null : !this._nwDstMask.equals(other._nwDstMask)) {
                return false;
            }
            if (this._nwSrcMask == null ? other._nwSrcMask != null : !this._nwSrcMask.equals(other._nwSrcMask)) {
                return false;
            }
            if (this._tableId == null ? other._tableId != null : !this._tableId.equals(other._tableId)) {
                return false;
            }
            if (this._wildcards == null ? other._wildcards != null : !this._wildcards.equals(other._wildcards)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("TableStats [_activeCount=");
            builder.append(this._activeCount);
            builder.append(", _lookupCount=");
            builder.append(this._lookupCount);
            builder.append(", _matchedCount=");
            builder.append(this._matchedCount);
            builder.append(", _maxEntries=");
            builder.append(this._maxEntries);
            builder.append(", _name=");
            builder.append(this._name);
            builder.append(", _nwDstMask=");
            builder.append(this._nwDstMask);
            builder.append(", _nwSrcMask=");
            builder.append(this._nwSrcMask);
            builder.append(", _tableId=");
            builder.append(this._tableId);
            builder.append(", _wildcards=");
            builder.append(this._wildcards);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

