/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.queue._case.multipart.reply.queue;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.queue._case.multipart.reply.queue.QueueStats;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class QueueStatsBuilder {
    private Long _durationNsec;
    private Long _durationSec;
    private Long _portNo;
    private Long _queueId;
    private BigInteger _txBytes;
    private BigInteger _txErrors;
    private BigInteger _txPackets;
    private Map<Class<? extends Augmentation<QueueStats>>, Augmentation<QueueStats>> augmentation = new HashMap<Class<? extends Augmentation<QueueStats>>, Augmentation<QueueStats>>();

    public Long getDurationNsec() {
        return this._durationNsec;
    }

    public Long getDurationSec() {
        return this._durationSec;
    }

    public Long getPortNo() {
        return this._portNo;
    }

    public Long getQueueId() {
        return this._queueId;
    }

    public BigInteger getTxBytes() {
        return this._txBytes;
    }

    public BigInteger getTxErrors() {
        return this._txErrors;
    }

    public BigInteger getTxPackets() {
        return this._txPackets;
    }

    public <E extends Augmentation<QueueStats>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public QueueStatsBuilder setDurationNsec(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._durationNsec = value;
        return this;
    }

    public QueueStatsBuilder setDurationSec(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._durationSec = value;
        return this;
    }

    public QueueStatsBuilder setPortNo(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._portNo = value;
        return this;
    }

    public QueueStatsBuilder setQueueId(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._queueId = value;
        return this;
    }

    public QueueStatsBuilder setTxBytes(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._txBytes = value;
        return this;
    }

    public QueueStatsBuilder setTxErrors(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._txErrors = value;
        return this;
    }

    public QueueStatsBuilder setTxPackets(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._txPackets = value;
        return this;
    }

    public QueueStatsBuilder addAugmentation(Class<? extends Augmentation<QueueStats>> augmentationType, Augmentation<QueueStats> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public QueueStats build() {
        return new QueueStatsImpl(this);
    }

    private static final class QueueStatsImpl
    implements QueueStats {
        private final Long _durationNsec;
        private final Long _durationSec;
        private final Long _portNo;
        private final Long _queueId;
        private final BigInteger _txBytes;
        private final BigInteger _txErrors;
        private final BigInteger _txPackets;
        private Map<Class<? extends Augmentation<QueueStats>>, Augmentation<QueueStats>> augmentation = new HashMap<Class<? extends Augmentation<QueueStats>>, Augmentation<QueueStats>>();

        public Class<QueueStats> getImplementedInterface() {
            return QueueStats.class;
        }

        private QueueStatsImpl(QueueStatsBuilder builder) {
            this._durationNsec = builder.getDurationNsec();
            this._durationSec = builder.getDurationSec();
            this._portNo = builder.getPortNo();
            this._queueId = builder.getQueueId();
            this._txBytes = builder.getTxBytes();
            this._txErrors = builder.getTxErrors();
            this._txPackets = builder.getTxPackets();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Long getDurationNsec() {
            return this._durationNsec;
        }

        @Override
        public Long getDurationSec() {
            return this._durationSec;
        }

        @Override
        public Long getPortNo() {
            return this._portNo;
        }

        @Override
        public Long getQueueId() {
            return this._queueId;
        }

        @Override
        public BigInteger getTxBytes() {
            return this._txBytes;
        }

        @Override
        public BigInteger getTxErrors() {
            return this._txErrors;
        }

        @Override
        public BigInteger getTxPackets() {
            return this._txPackets;
        }

        public <E extends Augmentation<QueueStats>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._durationNsec == null ? 0 : this._durationNsec.hashCode());
            result = 31 * result + (this._durationSec == null ? 0 : this._durationSec.hashCode());
            result = 31 * result + (this._portNo == null ? 0 : this._portNo.hashCode());
            result = 31 * result + (this._queueId == null ? 0 : this._queueId.hashCode());
            result = 31 * result + (this._txBytes == null ? 0 : this._txBytes.hashCode());
            result = 31 * result + (this._txErrors == null ? 0 : this._txErrors.hashCode());
            result = 31 * result + (this._txPackets == null ? 0 : this._txPackets.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QueueStatsImpl other = (QueueStatsImpl)obj;
            if (this._durationNsec == null ? other._durationNsec != null : !this._durationNsec.equals(other._durationNsec)) {
                return false;
            }
            if (this._durationSec == null ? other._durationSec != null : !this._durationSec.equals(other._durationSec)) {
                return false;
            }
            if (this._portNo == null ? other._portNo != null : !this._portNo.equals(other._portNo)) {
                return false;
            }
            if (this._queueId == null ? other._queueId != null : !this._queueId.equals(other._queueId)) {
                return false;
            }
            if (this._txBytes == null ? other._txBytes != null : !this._txBytes.equals(other._txBytes)) {
                return false;
            }
            if (this._txErrors == null ? other._txErrors != null : !this._txErrors.equals(other._txErrors)) {
                return false;
            }
            if (this._txPackets == null ? other._txPackets != null : !this._txPackets.equals(other._txPackets)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("QueueStats [_durationNsec=");
            builder.append(this._durationNsec);
            builder.append(", _durationSec=");
            builder.append(this._durationSec);
            builder.append(", _portNo=");
            builder.append(this._portNo);
            builder.append(", _queueId=");
            builder.append(this._queueId);
            builder.append(", _txBytes=");
            builder.append(this._txBytes);
            builder.append(", _txErrors=");
            builder.append(this._txErrors);
            builder.append(", _txPackets=");
            builder.append(this._txPackets);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

