/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.stats._case.multipart.reply.port.stats;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.stats._case.multipart.reply.port.stats.PortStats;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class PortStatsBuilder {
    private BigInteger _collisions;
    private Long _durationNsec;
    private Long _durationSec;
    private Long _portNo;
    private BigInteger _rxBytes;
    private BigInteger _rxCrcErr;
    private BigInteger _rxDropped;
    private BigInteger _rxErrors;
    private BigInteger _rxFrameErr;
    private BigInteger _rxOverErr;
    private BigInteger _rxPackets;
    private BigInteger _txBytes;
    private BigInteger _txDropped;
    private BigInteger _txErrors;
    private BigInteger _txPackets;
    private Map<Class<? extends Augmentation<PortStats>>, Augmentation<PortStats>> augmentation = new HashMap<Class<? extends Augmentation<PortStats>>, Augmentation<PortStats>>();

    public BigInteger getCollisions() {
        return this._collisions;
    }

    public Long getDurationNsec() {
        return this._durationNsec;
    }

    public Long getDurationSec() {
        return this._durationSec;
    }

    public Long getPortNo() {
        return this._portNo;
    }

    public BigInteger getRxBytes() {
        return this._rxBytes;
    }

    public BigInteger getRxCrcErr() {
        return this._rxCrcErr;
    }

    public BigInteger getRxDropped() {
        return this._rxDropped;
    }

    public BigInteger getRxErrors() {
        return this._rxErrors;
    }

    public BigInteger getRxFrameErr() {
        return this._rxFrameErr;
    }

    public BigInteger getRxOverErr() {
        return this._rxOverErr;
    }

    public BigInteger getRxPackets() {
        return this._rxPackets;
    }

    public BigInteger getTxBytes() {
        return this._txBytes;
    }

    public BigInteger getTxDropped() {
        return this._txDropped;
    }

    public BigInteger getTxErrors() {
        return this._txErrors;
    }

    public BigInteger getTxPackets() {
        return this._txPackets;
    }

    public <E extends Augmentation<PortStats>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PortStatsBuilder setCollisions(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._collisions = value;
        return this;
    }

    public PortStatsBuilder setDurationNsec(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._durationNsec = value;
        return this;
    }

    public PortStatsBuilder setDurationSec(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._durationSec = value;
        return this;
    }

    public PortStatsBuilder setPortNo(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._portNo = value;
        return this;
    }

    public PortStatsBuilder setRxBytes(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._rxBytes = value;
        return this;
    }

    public PortStatsBuilder setRxCrcErr(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._rxCrcErr = value;
        return this;
    }

    public PortStatsBuilder setRxDropped(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._rxDropped = value;
        return this;
    }

    public PortStatsBuilder setRxErrors(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._rxErrors = value;
        return this;
    }

    public PortStatsBuilder setRxFrameErr(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._rxFrameErr = value;
        return this;
    }

    public PortStatsBuilder setRxOverErr(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._rxOverErr = value;
        return this;
    }

    public PortStatsBuilder setRxPackets(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._rxPackets = value;
        return this;
    }

    public PortStatsBuilder setTxBytes(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._txBytes = value;
        return this;
    }

    public PortStatsBuilder setTxDropped(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._txDropped = value;
        return this;
    }

    public PortStatsBuilder setTxErrors(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._txErrors = value;
        return this;
    }

    public PortStatsBuilder setTxPackets(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._txPackets = value;
        return this;
    }

    public PortStatsBuilder addAugmentation(Class<? extends Augmentation<PortStats>> augmentationType, Augmentation<PortStats> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PortStats build() {
        return new PortStatsImpl(this);
    }

    private static final class PortStatsImpl
    implements PortStats {
        private final BigInteger _collisions;
        private final Long _durationNsec;
        private final Long _durationSec;
        private final Long _portNo;
        private final BigInteger _rxBytes;
        private final BigInteger _rxCrcErr;
        private final BigInteger _rxDropped;
        private final BigInteger _rxErrors;
        private final BigInteger _rxFrameErr;
        private final BigInteger _rxOverErr;
        private final BigInteger _rxPackets;
        private final BigInteger _txBytes;
        private final BigInteger _txDropped;
        private final BigInteger _txErrors;
        private final BigInteger _txPackets;
        private Map<Class<? extends Augmentation<PortStats>>, Augmentation<PortStats>> augmentation = new HashMap<Class<? extends Augmentation<PortStats>>, Augmentation<PortStats>>();

        public Class<PortStats> getImplementedInterface() {
            return PortStats.class;
        }

        private PortStatsImpl(PortStatsBuilder builder) {
            this._collisions = builder.getCollisions();
            this._durationNsec = builder.getDurationNsec();
            this._durationSec = builder.getDurationSec();
            this._portNo = builder.getPortNo();
            this._rxBytes = builder.getRxBytes();
            this._rxCrcErr = builder.getRxCrcErr();
            this._rxDropped = builder.getRxDropped();
            this._rxErrors = builder.getRxErrors();
            this._rxFrameErr = builder.getRxFrameErr();
            this._rxOverErr = builder.getRxOverErr();
            this._rxPackets = builder.getRxPackets();
            this._txBytes = builder.getTxBytes();
            this._txDropped = builder.getTxDropped();
            this._txErrors = builder.getTxErrors();
            this._txPackets = builder.getTxPackets();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public BigInteger getCollisions() {
            return this._collisions;
        }

        @Override
        public Long getDurationNsec() {
            return this._durationNsec;
        }

        @Override
        public Long getDurationSec() {
            return this._durationSec;
        }

        @Override
        public Long getPortNo() {
            return this._portNo;
        }

        @Override
        public BigInteger getRxBytes() {
            return this._rxBytes;
        }

        @Override
        public BigInteger getRxCrcErr() {
            return this._rxCrcErr;
        }

        @Override
        public BigInteger getRxDropped() {
            return this._rxDropped;
        }

        @Override
        public BigInteger getRxErrors() {
            return this._rxErrors;
        }

        @Override
        public BigInteger getRxFrameErr() {
            return this._rxFrameErr;
        }

        @Override
        public BigInteger getRxOverErr() {
            return this._rxOverErr;
        }

        @Override
        public BigInteger getRxPackets() {
            return this._rxPackets;
        }

        @Override
        public BigInteger getTxBytes() {
            return this._txBytes;
        }

        @Override
        public BigInteger getTxDropped() {
            return this._txDropped;
        }

        @Override
        public BigInteger getTxErrors() {
            return this._txErrors;
        }

        @Override
        public BigInteger getTxPackets() {
            return this._txPackets;
        }

        public <E extends Augmentation<PortStats>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._collisions == null ? 0 : this._collisions.hashCode());
            result = 31 * result + (this._durationNsec == null ? 0 : this._durationNsec.hashCode());
            result = 31 * result + (this._durationSec == null ? 0 : this._durationSec.hashCode());
            result = 31 * result + (this._portNo == null ? 0 : this._portNo.hashCode());
            result = 31 * result + (this._rxBytes == null ? 0 : this._rxBytes.hashCode());
            result = 31 * result + (this._rxCrcErr == null ? 0 : this._rxCrcErr.hashCode());
            result = 31 * result + (this._rxDropped == null ? 0 : this._rxDropped.hashCode());
            result = 31 * result + (this._rxErrors == null ? 0 : this._rxErrors.hashCode());
            result = 31 * result + (this._rxFrameErr == null ? 0 : this._rxFrameErr.hashCode());
            result = 31 * result + (this._rxOverErr == null ? 0 : this._rxOverErr.hashCode());
            result = 31 * result + (this._rxPackets == null ? 0 : this._rxPackets.hashCode());
            result = 31 * result + (this._txBytes == null ? 0 : this._txBytes.hashCode());
            result = 31 * result + (this._txDropped == null ? 0 : this._txDropped.hashCode());
            result = 31 * result + (this._txErrors == null ? 0 : this._txErrors.hashCode());
            result = 31 * result + (this._txPackets == null ? 0 : this._txPackets.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PortStatsImpl other = (PortStatsImpl)obj;
            if (this._collisions == null ? other._collisions != null : !this._collisions.equals(other._collisions)) {
                return false;
            }
            if (this._durationNsec == null ? other._durationNsec != null : !this._durationNsec.equals(other._durationNsec)) {
                return false;
            }
            if (this._durationSec == null ? other._durationSec != null : !this._durationSec.equals(other._durationSec)) {
                return false;
            }
            if (this._portNo == null ? other._portNo != null : !this._portNo.equals(other._portNo)) {
                return false;
            }
            if (this._rxBytes == null ? other._rxBytes != null : !this._rxBytes.equals(other._rxBytes)) {
                return false;
            }
            if (this._rxCrcErr == null ? other._rxCrcErr != null : !this._rxCrcErr.equals(other._rxCrcErr)) {
                return false;
            }
            if (this._rxDropped == null ? other._rxDropped != null : !this._rxDropped.equals(other._rxDropped)) {
                return false;
            }
            if (this._rxErrors == null ? other._rxErrors != null : !this._rxErrors.equals(other._rxErrors)) {
                return false;
            }
            if (this._rxFrameErr == null ? other._rxFrameErr != null : !this._rxFrameErr.equals(other._rxFrameErr)) {
                return false;
            }
            if (this._rxOverErr == null ? other._rxOverErr != null : !this._rxOverErr.equals(other._rxOverErr)) {
                return false;
            }
            if (this._rxPackets == null ? other._rxPackets != null : !this._rxPackets.equals(other._rxPackets)) {
                return false;
            }
            if (this._txBytes == null ? other._txBytes != null : !this._txBytes.equals(other._txBytes)) {
                return false;
            }
            if (this._txDropped == null ? other._txDropped != null : !this._txDropped.equals(other._txDropped)) {
                return false;
            }
            if (this._txErrors == null ? other._txErrors != null : !this._txErrors.equals(other._txErrors)) {
                return false;
            }
            if (this._txPackets == null ? other._txPackets != null : !this._txPackets.equals(other._txPackets)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("PortStats [_collisions=");
            builder.append(this._collisions);
            builder.append(", _durationNsec=");
            builder.append(this._durationNsec);
            builder.append(", _durationSec=");
            builder.append(this._durationSec);
            builder.append(", _portNo=");
            builder.append(this._portNo);
            builder.append(", _rxBytes=");
            builder.append(this._rxBytes);
            builder.append(", _rxCrcErr=");
            builder.append(this._rxCrcErr);
            builder.append(", _rxDropped=");
            builder.append(this._rxDropped);
            builder.append(", _rxErrors=");
            builder.append(this._rxErrors);
            builder.append(", _rxFrameErr=");
            builder.append(this._rxFrameErr);
            builder.append(", _rxOverErr=");
            builder.append(this._rxOverErr);
            builder.append(", _rxPackets=");
            builder.append(this._rxPackets);
            builder.append(", _txBytes=");
            builder.append(this._txBytes);
            builder.append(", _txDropped=");
            builder.append(this._txDropped);
            builder.append(", _txErrors=");
            builder.append(this._txErrors);
            builder.append(", _txPackets=");
            builder.append(this._txPackets);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

