/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.desc._case.multipart.reply.port.desc;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfigV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeaturesV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortState;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortStateV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.Port;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.desc._case.multipart.reply.port.desc.Ports;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PortsBuilder {
    private PortFeatures _advertisedFeatures;
    private PortFeaturesV10 _advertisedFeaturesV10;
    private PortConfig _config;
    private PortConfigV10 _configV10;
    private Long _currSpeed;
    private PortFeatures _currentFeatures;
    private PortFeaturesV10 _currentFeaturesV10;
    private MacAddress _hwAddr;
    private Long _maxSpeed;
    private String _name;
    private PortFeatures _peerFeatures;
    private PortFeaturesV10 _peerFeaturesV10;
    private Long _portNo;
    private PortState _state;
    private PortStateV10 _stateV10;
    private PortFeatures _supportedFeatures;
    private PortFeaturesV10 _supportedFeaturesV10;
    private Map<Class<? extends Augmentation<Ports>>, Augmentation<Ports>> augmentation = new HashMap<Class<? extends Augmentation<Ports>>, Augmentation<Ports>>();

    public PortsBuilder() {
    }

    public PortsBuilder(Port arg) {
        this._advertisedFeatures = arg.getAdvertisedFeatures();
        this._advertisedFeaturesV10 = arg.getAdvertisedFeaturesV10();
        this._config = arg.getConfig();
        this._configV10 = arg.getConfigV10();
        this._currSpeed = arg.getCurrSpeed();
        this._currentFeatures = arg.getCurrentFeatures();
        this._currentFeaturesV10 = arg.getCurrentFeaturesV10();
        this._hwAddr = arg.getHwAddr();
        this._maxSpeed = arg.getMaxSpeed();
        this._name = arg.getName();
        this._peerFeatures = arg.getPeerFeatures();
        this._peerFeaturesV10 = arg.getPeerFeaturesV10();
        this._portNo = arg.getPortNo();
        this._state = arg.getState();
        this._stateV10 = arg.getStateV10();
        this._supportedFeatures = arg.getSupportedFeatures();
        this._supportedFeaturesV10 = arg.getSupportedFeaturesV10();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Port) {
            this._advertisedFeatures = ((Port)arg).getAdvertisedFeatures();
            this._advertisedFeaturesV10 = ((Port)arg).getAdvertisedFeaturesV10();
            this._config = ((Port)arg).getConfig();
            this._configV10 = ((Port)arg).getConfigV10();
            this._currSpeed = ((Port)arg).getCurrSpeed();
            this._currentFeatures = ((Port)arg).getCurrentFeatures();
            this._currentFeaturesV10 = ((Port)arg).getCurrentFeaturesV10();
            this._hwAddr = ((Port)arg).getHwAddr();
            this._maxSpeed = ((Port)arg).getMaxSpeed();
            this._name = ((Port)arg).getName();
            this._peerFeatures = ((Port)arg).getPeerFeatures();
            this._peerFeaturesV10 = ((Port)arg).getPeerFeaturesV10();
            this._portNo = ((Port)arg).getPortNo();
            this._state = ((Port)arg).getState();
            this._stateV10 = ((Port)arg).getStateV10();
            this._supportedFeatures = ((Port)arg).getSupportedFeatures();
            this._supportedFeaturesV10 = ((Port)arg).getSupportedFeaturesV10();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.Port] \nbut was: " + arg);
        }
    }

    public PortFeatures getAdvertisedFeatures() {
        return this._advertisedFeatures;
    }

    public PortFeaturesV10 getAdvertisedFeaturesV10() {
        return this._advertisedFeaturesV10;
    }

    public PortConfig getConfig() {
        return this._config;
    }

    public PortConfigV10 getConfigV10() {
        return this._configV10;
    }

    public Long getCurrSpeed() {
        return this._currSpeed;
    }

    public PortFeatures getCurrentFeatures() {
        return this._currentFeatures;
    }

    public PortFeaturesV10 getCurrentFeaturesV10() {
        return this._currentFeaturesV10;
    }

    public MacAddress getHwAddr() {
        return this._hwAddr;
    }

    public Long getMaxSpeed() {
        return this._maxSpeed;
    }

    public String getName() {
        return this._name;
    }

    public PortFeatures getPeerFeatures() {
        return this._peerFeatures;
    }

    public PortFeaturesV10 getPeerFeaturesV10() {
        return this._peerFeaturesV10;
    }

    public Long getPortNo() {
        return this._portNo;
    }

    public PortState getState() {
        return this._state;
    }

    public PortStateV10 getStateV10() {
        return this._stateV10;
    }

    public PortFeatures getSupportedFeatures() {
        return this._supportedFeatures;
    }

    public PortFeaturesV10 getSupportedFeaturesV10() {
        return this._supportedFeaturesV10;
    }

    public <E extends Augmentation<Ports>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PortsBuilder setAdvertisedFeatures(PortFeatures value) {
        this._advertisedFeatures = value;
        return this;
    }

    public PortsBuilder setAdvertisedFeaturesV10(PortFeaturesV10 value) {
        this._advertisedFeaturesV10 = value;
        return this;
    }

    public PortsBuilder setConfig(PortConfig value) {
        this._config = value;
        return this;
    }

    public PortsBuilder setConfigV10(PortConfigV10 value) {
        this._configV10 = value;
        return this;
    }

    public PortsBuilder setCurrSpeed(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._currSpeed = value;
        return this;
    }

    public PortsBuilder setCurrentFeatures(PortFeatures value) {
        this._currentFeatures = value;
        return this;
    }

    public PortsBuilder setCurrentFeaturesV10(PortFeaturesV10 value) {
        this._currentFeaturesV10 = value;
        return this;
    }

    public PortsBuilder setHwAddr(MacAddress value) {
        this._hwAddr = value;
        return this;
    }

    public PortsBuilder setMaxSpeed(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._maxSpeed = value;
        return this;
    }

    public PortsBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public PortsBuilder setPeerFeatures(PortFeatures value) {
        this._peerFeatures = value;
        return this;
    }

    public PortsBuilder setPeerFeaturesV10(PortFeaturesV10 value) {
        this._peerFeaturesV10 = value;
        return this;
    }

    public PortsBuilder setPortNo(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._portNo = value;
        return this;
    }

    public PortsBuilder setState(PortState value) {
        this._state = value;
        return this;
    }

    public PortsBuilder setStateV10(PortStateV10 value) {
        this._stateV10 = value;
        return this;
    }

    public PortsBuilder setSupportedFeatures(PortFeatures value) {
        this._supportedFeatures = value;
        return this;
    }

    public PortsBuilder setSupportedFeaturesV10(PortFeaturesV10 value) {
        this._supportedFeaturesV10 = value;
        return this;
    }

    public PortsBuilder addAugmentation(Class<? extends Augmentation<Ports>> augmentationType, Augmentation<Ports> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Ports build() {
        return new PortsImpl(this);
    }

    private static final class PortsImpl
    implements Ports {
        private final PortFeatures _advertisedFeatures;
        private final PortFeaturesV10 _advertisedFeaturesV10;
        private final PortConfig _config;
        private final PortConfigV10 _configV10;
        private final Long _currSpeed;
        private final PortFeatures _currentFeatures;
        private final PortFeaturesV10 _currentFeaturesV10;
        private final MacAddress _hwAddr;
        private final Long _maxSpeed;
        private final String _name;
        private final PortFeatures _peerFeatures;
        private final PortFeaturesV10 _peerFeaturesV10;
        private final Long _portNo;
        private final PortState _state;
        private final PortStateV10 _stateV10;
        private final PortFeatures _supportedFeatures;
        private final PortFeaturesV10 _supportedFeaturesV10;
        private Map<Class<? extends Augmentation<Ports>>, Augmentation<Ports>> augmentation = new HashMap<Class<? extends Augmentation<Ports>>, Augmentation<Ports>>();

        public Class<Ports> getImplementedInterface() {
            return Ports.class;
        }

        private PortsImpl(PortsBuilder builder) {
            this._advertisedFeatures = builder.getAdvertisedFeatures();
            this._advertisedFeaturesV10 = builder.getAdvertisedFeaturesV10();
            this._config = builder.getConfig();
            this._configV10 = builder.getConfigV10();
            this._currSpeed = builder.getCurrSpeed();
            this._currentFeatures = builder.getCurrentFeatures();
            this._currentFeaturesV10 = builder.getCurrentFeaturesV10();
            this._hwAddr = builder.getHwAddr();
            this._maxSpeed = builder.getMaxSpeed();
            this._name = builder.getName();
            this._peerFeatures = builder.getPeerFeatures();
            this._peerFeaturesV10 = builder.getPeerFeaturesV10();
            this._portNo = builder.getPortNo();
            this._state = builder.getState();
            this._stateV10 = builder.getStateV10();
            this._supportedFeatures = builder.getSupportedFeatures();
            this._supportedFeaturesV10 = builder.getSupportedFeaturesV10();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public PortFeatures getAdvertisedFeatures() {
            return this._advertisedFeatures;
        }

        @Override
        public PortFeaturesV10 getAdvertisedFeaturesV10() {
            return this._advertisedFeaturesV10;
        }

        @Override
        public PortConfig getConfig() {
            return this._config;
        }

        @Override
        public PortConfigV10 getConfigV10() {
            return this._configV10;
        }

        @Override
        public Long getCurrSpeed() {
            return this._currSpeed;
        }

        @Override
        public PortFeatures getCurrentFeatures() {
            return this._currentFeatures;
        }

        @Override
        public PortFeaturesV10 getCurrentFeaturesV10() {
            return this._currentFeaturesV10;
        }

        @Override
        public MacAddress getHwAddr() {
            return this._hwAddr;
        }

        @Override
        public Long getMaxSpeed() {
            return this._maxSpeed;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public PortFeatures getPeerFeatures() {
            return this._peerFeatures;
        }

        @Override
        public PortFeaturesV10 getPeerFeaturesV10() {
            return this._peerFeaturesV10;
        }

        @Override
        public Long getPortNo() {
            return this._portNo;
        }

        @Override
        public PortState getState() {
            return this._state;
        }

        @Override
        public PortStateV10 getStateV10() {
            return this._stateV10;
        }

        @Override
        public PortFeatures getSupportedFeatures() {
            return this._supportedFeatures;
        }

        @Override
        public PortFeaturesV10 getSupportedFeaturesV10() {
            return this._supportedFeaturesV10;
        }

        public <E extends Augmentation<Ports>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._advertisedFeatures == null ? 0 : this._advertisedFeatures.hashCode());
            result = 31 * result + (this._advertisedFeaturesV10 == null ? 0 : this._advertisedFeaturesV10.hashCode());
            result = 31 * result + (this._config == null ? 0 : this._config.hashCode());
            result = 31 * result + (this._configV10 == null ? 0 : this._configV10.hashCode());
            result = 31 * result + (this._currSpeed == null ? 0 : this._currSpeed.hashCode());
            result = 31 * result + (this._currentFeatures == null ? 0 : this._currentFeatures.hashCode());
            result = 31 * result + (this._currentFeaturesV10 == null ? 0 : this._currentFeaturesV10.hashCode());
            result = 31 * result + (this._hwAddr == null ? 0 : this._hwAddr.hashCode());
            result = 31 * result + (this._maxSpeed == null ? 0 : this._maxSpeed.hashCode());
            result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
            result = 31 * result + (this._peerFeatures == null ? 0 : this._peerFeatures.hashCode());
            result = 31 * result + (this._peerFeaturesV10 == null ? 0 : this._peerFeaturesV10.hashCode());
            result = 31 * result + (this._portNo == null ? 0 : this._portNo.hashCode());
            result = 31 * result + (this._state == null ? 0 : this._state.hashCode());
            result = 31 * result + (this._stateV10 == null ? 0 : this._stateV10.hashCode());
            result = 31 * result + (this._supportedFeatures == null ? 0 : this._supportedFeatures.hashCode());
            result = 31 * result + (this._supportedFeaturesV10 == null ? 0 : this._supportedFeaturesV10.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PortsImpl other = (PortsImpl)obj;
            if (this._advertisedFeatures == null ? other._advertisedFeatures != null : !this._advertisedFeatures.equals(other._advertisedFeatures)) {
                return false;
            }
            if (this._advertisedFeaturesV10 == null ? other._advertisedFeaturesV10 != null : !this._advertisedFeaturesV10.equals(other._advertisedFeaturesV10)) {
                return false;
            }
            if (this._config == null ? other._config != null : !this._config.equals(other._config)) {
                return false;
            }
            if (this._configV10 == null ? other._configV10 != null : !this._configV10.equals(other._configV10)) {
                return false;
            }
            if (this._currSpeed == null ? other._currSpeed != null : !this._currSpeed.equals(other._currSpeed)) {
                return false;
            }
            if (this._currentFeatures == null ? other._currentFeatures != null : !this._currentFeatures.equals(other._currentFeatures)) {
                return false;
            }
            if (this._currentFeaturesV10 == null ? other._currentFeaturesV10 != null : !this._currentFeaturesV10.equals(other._currentFeaturesV10)) {
                return false;
            }
            if (this._hwAddr == null ? other._hwAddr != null : !this._hwAddr.equals((Object)other._hwAddr)) {
                return false;
            }
            if (this._maxSpeed == null ? other._maxSpeed != null : !this._maxSpeed.equals(other._maxSpeed)) {
                return false;
            }
            if (this._name == null ? other._name != null : !this._name.equals(other._name)) {
                return false;
            }
            if (this._peerFeatures == null ? other._peerFeatures != null : !this._peerFeatures.equals(other._peerFeatures)) {
                return false;
            }
            if (this._peerFeaturesV10 == null ? other._peerFeaturesV10 != null : !this._peerFeaturesV10.equals(other._peerFeaturesV10)) {
                return false;
            }
            if (this._portNo == null ? other._portNo != null : !this._portNo.equals(other._portNo)) {
                return false;
            }
            if (this._state == null ? other._state != null : !this._state.equals(other._state)) {
                return false;
            }
            if (this._stateV10 == null ? other._stateV10 != null : !this._stateV10.equals(other._stateV10)) {
                return false;
            }
            if (this._supportedFeatures == null ? other._supportedFeatures != null : !this._supportedFeatures.equals(other._supportedFeatures)) {
                return false;
            }
            if (this._supportedFeaturesV10 == null ? other._supportedFeaturesV10 != null : !this._supportedFeaturesV10.equals(other._supportedFeaturesV10)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Ports [_advertisedFeatures=");
            builder.append(this._advertisedFeatures);
            builder.append(", _advertisedFeaturesV10=");
            builder.append(this._advertisedFeaturesV10);
            builder.append(", _config=");
            builder.append(this._config);
            builder.append(", _configV10=");
            builder.append(this._configV10);
            builder.append(", _currSpeed=");
            builder.append(this._currSpeed);
            builder.append(", _currentFeatures=");
            builder.append(this._currentFeatures);
            builder.append(", _currentFeaturesV10=");
            builder.append(this._currentFeaturesV10);
            builder.append(", _hwAddr=");
            builder.append(this._hwAddr);
            builder.append(", _maxSpeed=");
            builder.append(this._maxSpeed);
            builder.append(", _name=");
            builder.append(this._name);
            builder.append(", _peerFeatures=");
            builder.append(this._peerFeatures);
            builder.append(", _peerFeaturesV10=");
            builder.append(this._peerFeaturesV10);
            builder.append(", _portNo=");
            builder.append(this._portNo);
            builder.append(", _state=");
            builder.append(this._state);
            builder.append(", _stateV10=");
            builder.append(this._stateV10);
            builder.append(", _supportedFeatures=");
            builder.append(this._supportedFeatures);
            builder.append(", _supportedFeaturesV10=");
            builder.append(this._supportedFeaturesV10);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

