/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.features._case;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterBandTypeBitmap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.features._case.MultipartReplyMeterFeatures;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class MultipartReplyMeterFeaturesBuilder {
    private MeterBandTypeBitmap _bandTypes;
    private MeterFlags _capabilities;
    private Short _maxBands;
    private Short _maxColor;
    private Long _maxMeter;
    private Map<Class<? extends Augmentation<MultipartReplyMeterFeatures>>, Augmentation<MultipartReplyMeterFeatures>> augmentation = new HashMap<Class<? extends Augmentation<MultipartReplyMeterFeatures>>, Augmentation<MultipartReplyMeterFeatures>>();

    public MeterBandTypeBitmap getBandTypes() {
        return this._bandTypes;
    }

    public MeterFlags getCapabilities() {
        return this._capabilities;
    }

    public Short getMaxBands() {
        return this._maxBands;
    }

    public Short getMaxColor() {
        return this._maxColor;
    }

    public Long getMaxMeter() {
        return this._maxMeter;
    }

    public <E extends Augmentation<MultipartReplyMeterFeatures>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MultipartReplyMeterFeaturesBuilder setBandTypes(MeterBandTypeBitmap value) {
        this._bandTypes = value;
        return this;
    }

    public MultipartReplyMeterFeaturesBuilder setCapabilities(MeterFlags value) {
        this._capabilities = value;
        return this;
    }

    public MultipartReplyMeterFeaturesBuilder setMaxBands(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._maxBands = value;
        return this;
    }

    public MultipartReplyMeterFeaturesBuilder setMaxColor(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._maxColor = value;
        return this;
    }

    public MultipartReplyMeterFeaturesBuilder setMaxMeter(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._maxMeter = value;
        return this;
    }

    public MultipartReplyMeterFeaturesBuilder addAugmentation(Class<? extends Augmentation<MultipartReplyMeterFeatures>> augmentationType, Augmentation<MultipartReplyMeterFeatures> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MultipartReplyMeterFeatures build() {
        return new MultipartReplyMeterFeaturesImpl(this);
    }

    private static final class MultipartReplyMeterFeaturesImpl
    implements MultipartReplyMeterFeatures {
        private final MeterBandTypeBitmap _bandTypes;
        private final MeterFlags _capabilities;
        private final Short _maxBands;
        private final Short _maxColor;
        private final Long _maxMeter;
        private Map<Class<? extends Augmentation<MultipartReplyMeterFeatures>>, Augmentation<MultipartReplyMeterFeatures>> augmentation = new HashMap<Class<? extends Augmentation<MultipartReplyMeterFeatures>>, Augmentation<MultipartReplyMeterFeatures>>();

        public Class<MultipartReplyMeterFeatures> getImplementedInterface() {
            return MultipartReplyMeterFeatures.class;
        }

        private MultipartReplyMeterFeaturesImpl(MultipartReplyMeterFeaturesBuilder builder) {
            this._bandTypes = builder.getBandTypes();
            this._capabilities = builder.getCapabilities();
            this._maxBands = builder.getMaxBands();
            this._maxColor = builder.getMaxColor();
            this._maxMeter = builder.getMaxMeter();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public MeterBandTypeBitmap getBandTypes() {
            return this._bandTypes;
        }

        @Override
        public MeterFlags getCapabilities() {
            return this._capabilities;
        }

        @Override
        public Short getMaxBands() {
            return this._maxBands;
        }

        @Override
        public Short getMaxColor() {
            return this._maxColor;
        }

        @Override
        public Long getMaxMeter() {
            return this._maxMeter;
        }

        public <E extends Augmentation<MultipartReplyMeterFeatures>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._bandTypes == null ? 0 : this._bandTypes.hashCode());
            result = 31 * result + (this._capabilities == null ? 0 : this._capabilities.hashCode());
            result = 31 * result + (this._maxBands == null ? 0 : this._maxBands.hashCode());
            result = 31 * result + (this._maxColor == null ? 0 : this._maxColor.hashCode());
            result = 31 * result + (this._maxMeter == null ? 0 : this._maxMeter.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MultipartReplyMeterFeaturesImpl other = (MultipartReplyMeterFeaturesImpl)obj;
            if (this._bandTypes == null ? other._bandTypes != null : !this._bandTypes.equals(other._bandTypes)) {
                return false;
            }
            if (this._capabilities == null ? other._capabilities != null : !this._capabilities.equals(other._capabilities)) {
                return false;
            }
            if (this._maxBands == null ? other._maxBands != null : !this._maxBands.equals(other._maxBands)) {
                return false;
            }
            if (this._maxColor == null ? other._maxColor != null : !this._maxColor.equals(other._maxColor)) {
                return false;
            }
            if (this._maxMeter == null ? other._maxMeter != null : !this._maxMeter.equals(other._maxMeter)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MultipartReplyMeterFeatures [_bandTypes=");
            builder.append(this._bandTypes);
            builder.append(", _capabilities=");
            builder.append(this._capabilities);
            builder.append(", _maxBands=");
            builder.append(this._maxBands);
            builder.append(", _maxColor=");
            builder.append(this._maxColor);
            builder.append(", _maxMeter=");
            builder.append(this._maxMeter);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

