/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.config._case.multipart.reply.meter.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.config._case.multipart.reply.meter.config.MeterConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.config._case.multipart.reply.meter.config.meter.config.Bands;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class MeterConfigBuilder {
    private List<Bands> _bands;
    private MeterFlags _flags;
    private MeterId _meterId;
    private Map<Class<? extends Augmentation<MeterConfig>>, Augmentation<MeterConfig>> augmentation = new HashMap<Class<? extends Augmentation<MeterConfig>>, Augmentation<MeterConfig>>();

    public List<Bands> getBands() {
        return this._bands;
    }

    public MeterFlags getFlags() {
        return this._flags;
    }

    public MeterId getMeterId() {
        return this._meterId;
    }

    public <E extends Augmentation<MeterConfig>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MeterConfigBuilder setBands(List<Bands> value) {
        this._bands = value;
        return this;
    }

    public MeterConfigBuilder setFlags(MeterFlags value) {
        this._flags = value;
        return this;
    }

    public MeterConfigBuilder setMeterId(MeterId value) {
        this._meterId = value;
        return this;
    }

    public MeterConfigBuilder addAugmentation(Class<? extends Augmentation<MeterConfig>> augmentationType, Augmentation<MeterConfig> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MeterConfig build() {
        return new MeterConfigImpl(this);
    }

    private static final class MeterConfigImpl
    implements MeterConfig {
        private final List<Bands> _bands;
        private final MeterFlags _flags;
        private final MeterId _meterId;
        private Map<Class<? extends Augmentation<MeterConfig>>, Augmentation<MeterConfig>> augmentation = new HashMap<Class<? extends Augmentation<MeterConfig>>, Augmentation<MeterConfig>>();

        public Class<MeterConfig> getImplementedInterface() {
            return MeterConfig.class;
        }

        private MeterConfigImpl(MeterConfigBuilder builder) {
            this._bands = builder.getBands();
            this._flags = builder.getFlags();
            this._meterId = builder.getMeterId();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public List<Bands> getBands() {
            return this._bands;
        }

        @Override
        public MeterFlags getFlags() {
            return this._flags;
        }

        @Override
        public MeterId getMeterId() {
            return this._meterId;
        }

        public <E extends Augmentation<MeterConfig>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._bands == null ? 0 : this._bands.hashCode());
            result = 31 * result + (this._flags == null ? 0 : this._flags.hashCode());
            result = 31 * result + (this._meterId == null ? 0 : this._meterId.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MeterConfigImpl other = (MeterConfigImpl)obj;
            if (this._bands == null ? other._bands != null : !this._bands.equals(other._bands)) {
                return false;
            }
            if (this._flags == null ? other._flags != null : !this._flags.equals(other._flags)) {
                return false;
            }
            if (this._meterId == null ? other._meterId != null : !this._meterId.equals(other._meterId)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MeterConfig [_bands=");
            builder.append(this._bands);
            builder.append(", _flags=");
            builder.append(this._flags);
            builder.append(", _meterId=");
            builder.append(this._meterId);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

