/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.multipart.reply.meter.meter.stats;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.multipart.reply.meter.meter.stats.MeterBandStats;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class MeterBandStatsBuilder {
    private BigInteger _byteBandCount;
    private BigInteger _packetBandCount;
    private Map<Class<? extends Augmentation<MeterBandStats>>, Augmentation<MeterBandStats>> augmentation = new HashMap<Class<? extends Augmentation<MeterBandStats>>, Augmentation<MeterBandStats>>();

    public BigInteger getByteBandCount() {
        return this._byteBandCount;
    }

    public BigInteger getPacketBandCount() {
        return this._packetBandCount;
    }

    public <E extends Augmentation<MeterBandStats>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MeterBandStatsBuilder setByteBandCount(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._byteBandCount = value;
        return this;
    }

    public MeterBandStatsBuilder setPacketBandCount(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._packetBandCount = value;
        return this;
    }

    public MeterBandStatsBuilder addAugmentation(Class<? extends Augmentation<MeterBandStats>> augmentationType, Augmentation<MeterBandStats> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MeterBandStats build() {
        return new MeterBandStatsImpl(this);
    }

    private static final class MeterBandStatsImpl
    implements MeterBandStats {
        private final BigInteger _byteBandCount;
        private final BigInteger _packetBandCount;
        private Map<Class<? extends Augmentation<MeterBandStats>>, Augmentation<MeterBandStats>> augmentation = new HashMap<Class<? extends Augmentation<MeterBandStats>>, Augmentation<MeterBandStats>>();

        public Class<MeterBandStats> getImplementedInterface() {
            return MeterBandStats.class;
        }

        private MeterBandStatsImpl(MeterBandStatsBuilder builder) {
            this._byteBandCount = builder.getByteBandCount();
            this._packetBandCount = builder.getPacketBandCount();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public BigInteger getByteBandCount() {
            return this._byteBandCount;
        }

        @Override
        public BigInteger getPacketBandCount() {
            return this._packetBandCount;
        }

        public <E extends Augmentation<MeterBandStats>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._byteBandCount == null ? 0 : this._byteBandCount.hashCode());
            result = 31 * result + (this._packetBandCount == null ? 0 : this._packetBandCount.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MeterBandStatsImpl other = (MeterBandStatsImpl)obj;
            if (this._byteBandCount == null ? other._byteBandCount != null : !this._byteBandCount.equals(other._byteBandCount)) {
                return false;
            }
            if (this._packetBandCount == null ? other._packetBandCount != null : !this._packetBandCount.equals(other._packetBandCount)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MeterBandStats [_byteBandCount=");
            builder.append(this._byteBandCount);
            builder.append(", _packetBandCount=");
            builder.append(this._packetBandCount);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

