/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.multipart.reply.meter;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.multipart.reply.meter.MeterStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.multipart.reply.meter.meter.stats.MeterBandStats;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class MeterStatsBuilder {
    private BigInteger _byteInCount;
    private Long _durationNsec;
    private Long _durationSec;
    private Long _flowCount;
    private List<MeterBandStats> _meterBandStats;
    private MeterId _meterId;
    private BigInteger _packetInCount;
    private Map<Class<? extends Augmentation<MeterStats>>, Augmentation<MeterStats>> augmentation = new HashMap<Class<? extends Augmentation<MeterStats>>, Augmentation<MeterStats>>();

    public BigInteger getByteInCount() {
        return this._byteInCount;
    }

    public Long getDurationNsec() {
        return this._durationNsec;
    }

    public Long getDurationSec() {
        return this._durationSec;
    }

    public Long getFlowCount() {
        return this._flowCount;
    }

    public List<MeterBandStats> getMeterBandStats() {
        return this._meterBandStats;
    }

    public MeterId getMeterId() {
        return this._meterId;
    }

    public BigInteger getPacketInCount() {
        return this._packetInCount;
    }

    public <E extends Augmentation<MeterStats>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MeterStatsBuilder setByteInCount(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._byteInCount = value;
        return this;
    }

    public MeterStatsBuilder setDurationNsec(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._durationNsec = value;
        return this;
    }

    public MeterStatsBuilder setDurationSec(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._durationSec = value;
        return this;
    }

    public MeterStatsBuilder setFlowCount(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._flowCount = value;
        return this;
    }

    public MeterStatsBuilder setMeterBandStats(List<MeterBandStats> value) {
        this._meterBandStats = value;
        return this;
    }

    public MeterStatsBuilder setMeterId(MeterId value) {
        this._meterId = value;
        return this;
    }

    public MeterStatsBuilder setPacketInCount(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._packetInCount = value;
        return this;
    }

    public MeterStatsBuilder addAugmentation(Class<? extends Augmentation<MeterStats>> augmentationType, Augmentation<MeterStats> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MeterStats build() {
        return new MeterStatsImpl(this);
    }

    private static final class MeterStatsImpl
    implements MeterStats {
        private final BigInteger _byteInCount;
        private final Long _durationNsec;
        private final Long _durationSec;
        private final Long _flowCount;
        private final List<MeterBandStats> _meterBandStats;
        private final MeterId _meterId;
        private final BigInteger _packetInCount;
        private Map<Class<? extends Augmentation<MeterStats>>, Augmentation<MeterStats>> augmentation = new HashMap<Class<? extends Augmentation<MeterStats>>, Augmentation<MeterStats>>();

        public Class<MeterStats> getImplementedInterface() {
            return MeterStats.class;
        }

        private MeterStatsImpl(MeterStatsBuilder builder) {
            this._byteInCount = builder.getByteInCount();
            this._durationNsec = builder.getDurationNsec();
            this._durationSec = builder.getDurationSec();
            this._flowCount = builder.getFlowCount();
            this._meterBandStats = builder.getMeterBandStats();
            this._meterId = builder.getMeterId();
            this._packetInCount = builder.getPacketInCount();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public BigInteger getByteInCount() {
            return this._byteInCount;
        }

        @Override
        public Long getDurationNsec() {
            return this._durationNsec;
        }

        @Override
        public Long getDurationSec() {
            return this._durationSec;
        }

        @Override
        public Long getFlowCount() {
            return this._flowCount;
        }

        @Override
        public List<MeterBandStats> getMeterBandStats() {
            return this._meterBandStats;
        }

        @Override
        public MeterId getMeterId() {
            return this._meterId;
        }

        @Override
        public BigInteger getPacketInCount() {
            return this._packetInCount;
        }

        public <E extends Augmentation<MeterStats>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._byteInCount == null ? 0 : this._byteInCount.hashCode());
            result = 31 * result + (this._durationNsec == null ? 0 : this._durationNsec.hashCode());
            result = 31 * result + (this._durationSec == null ? 0 : this._durationSec.hashCode());
            result = 31 * result + (this._flowCount == null ? 0 : this._flowCount.hashCode());
            result = 31 * result + (this._meterBandStats == null ? 0 : this._meterBandStats.hashCode());
            result = 31 * result + (this._meterId == null ? 0 : this._meterId.hashCode());
            result = 31 * result + (this._packetInCount == null ? 0 : this._packetInCount.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MeterStatsImpl other = (MeterStatsImpl)obj;
            if (this._byteInCount == null ? other._byteInCount != null : !this._byteInCount.equals(other._byteInCount)) {
                return false;
            }
            if (this._durationNsec == null ? other._durationNsec != null : !this._durationNsec.equals(other._durationNsec)) {
                return false;
            }
            if (this._durationSec == null ? other._durationSec != null : !this._durationSec.equals(other._durationSec)) {
                return false;
            }
            if (this._flowCount == null ? other._flowCount != null : !this._flowCount.equals(other._flowCount)) {
                return false;
            }
            if (this._meterBandStats == null ? other._meterBandStats != null : !this._meterBandStats.equals(other._meterBandStats)) {
                return false;
            }
            if (this._meterId == null ? other._meterId != null : !this._meterId.equals(other._meterId)) {
                return false;
            }
            if (this._packetInCount == null ? other._packetInCount != null : !this._packetInCount.equals(other._packetInCount)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MeterStats [_byteInCount=");
            builder.append(this._byteInCount);
            builder.append(", _durationNsec=");
            builder.append(this._durationNsec);
            builder.append(", _durationSec=");
            builder.append(this._durationSec);
            builder.append(", _flowCount=");
            builder.append(this._flowCount);
            builder.append(", _meterBandStats=");
            builder.append(this._meterBandStats);
            builder.append(", _meterId=");
            builder.append(this._meterId);
            builder.append(", _packetInCount=");
            builder.append(this._packetInCount);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

