/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.multipart.reply.group.group.stats;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.multipart.reply.group.group.stats.BucketStats;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class BucketStatsBuilder {
    private BigInteger _byteCount;
    private BigInteger _packetCount;
    private Map<Class<? extends Augmentation<BucketStats>>, Augmentation<BucketStats>> augmentation = new HashMap<Class<? extends Augmentation<BucketStats>>, Augmentation<BucketStats>>();

    public BigInteger getByteCount() {
        return this._byteCount;
    }

    public BigInteger getPacketCount() {
        return this._packetCount;
    }

    public <E extends Augmentation<BucketStats>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public BucketStatsBuilder setByteCount(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._byteCount = value;
        return this;
    }

    public BucketStatsBuilder setPacketCount(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._packetCount = value;
        return this;
    }

    public BucketStatsBuilder addAugmentation(Class<? extends Augmentation<BucketStats>> augmentationType, Augmentation<BucketStats> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public BucketStats build() {
        return new BucketStatsImpl(this);
    }

    private static final class BucketStatsImpl
    implements BucketStats {
        private final BigInteger _byteCount;
        private final BigInteger _packetCount;
        private Map<Class<? extends Augmentation<BucketStats>>, Augmentation<BucketStats>> augmentation = new HashMap<Class<? extends Augmentation<BucketStats>>, Augmentation<BucketStats>>();

        public Class<BucketStats> getImplementedInterface() {
            return BucketStats.class;
        }

        private BucketStatsImpl(BucketStatsBuilder builder) {
            this._byteCount = builder.getByteCount();
            this._packetCount = builder.getPacketCount();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public BigInteger getByteCount() {
            return this._byteCount;
        }

        @Override
        public BigInteger getPacketCount() {
            return this._packetCount;
        }

        public <E extends Augmentation<BucketStats>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._byteCount == null ? 0 : this._byteCount.hashCode());
            result = 31 * result + (this._packetCount == null ? 0 : this._packetCount.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BucketStatsImpl other = (BucketStatsImpl)obj;
            if (this._byteCount == null ? other._byteCount != null : !this._byteCount.equals(other._byteCount)) {
                return false;
            }
            if (this._packetCount == null ? other._packetCount != null : !this._packetCount.equals(other._packetCount)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("BucketStats [_byteCount=");
            builder.append(this._byteCount);
            builder.append(", _packetCount=");
            builder.append(this._packetCount);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

