/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.multipart.reply.group;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.multipart.reply.group.GroupStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.multipart.reply.group.group.stats.BucketStats;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class GroupStatsBuilder {
    private List<BucketStats> _bucketStats;
    private BigInteger _byteCount;
    private Long _durationNsec;
    private Long _durationSec;
    private GroupId _groupId;
    private BigInteger _packetCount;
    private Long _refCount;
    private Map<Class<? extends Augmentation<GroupStats>>, Augmentation<GroupStats>> augmentation = new HashMap<Class<? extends Augmentation<GroupStats>>, Augmentation<GroupStats>>();

    public List<BucketStats> getBucketStats() {
        return this._bucketStats;
    }

    public BigInteger getByteCount() {
        return this._byteCount;
    }

    public Long getDurationNsec() {
        return this._durationNsec;
    }

    public Long getDurationSec() {
        return this._durationSec;
    }

    public GroupId getGroupId() {
        return this._groupId;
    }

    public BigInteger getPacketCount() {
        return this._packetCount;
    }

    public Long getRefCount() {
        return this._refCount;
    }

    public <E extends Augmentation<GroupStats>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public GroupStatsBuilder setBucketStats(List<BucketStats> value) {
        this._bucketStats = value;
        return this;
    }

    public GroupStatsBuilder setByteCount(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._byteCount = value;
        return this;
    }

    public GroupStatsBuilder setDurationNsec(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._durationNsec = value;
        return this;
    }

    public GroupStatsBuilder setDurationSec(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._durationSec = value;
        return this;
    }

    public GroupStatsBuilder setGroupId(GroupId value) {
        this._groupId = value;
        return this;
    }

    public GroupStatsBuilder setPacketCount(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._packetCount = value;
        return this;
    }

    public GroupStatsBuilder setRefCount(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._refCount = value;
        return this;
    }

    public GroupStatsBuilder addAugmentation(Class<? extends Augmentation<GroupStats>> augmentationType, Augmentation<GroupStats> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public GroupStats build() {
        return new GroupStatsImpl(this);
    }

    private static final class GroupStatsImpl
    implements GroupStats {
        private final List<BucketStats> _bucketStats;
        private final BigInteger _byteCount;
        private final Long _durationNsec;
        private final Long _durationSec;
        private final GroupId _groupId;
        private final BigInteger _packetCount;
        private final Long _refCount;
        private Map<Class<? extends Augmentation<GroupStats>>, Augmentation<GroupStats>> augmentation = new HashMap<Class<? extends Augmentation<GroupStats>>, Augmentation<GroupStats>>();

        public Class<GroupStats> getImplementedInterface() {
            return GroupStats.class;
        }

        private GroupStatsImpl(GroupStatsBuilder builder) {
            this._bucketStats = builder.getBucketStats();
            this._byteCount = builder.getByteCount();
            this._durationNsec = builder.getDurationNsec();
            this._durationSec = builder.getDurationSec();
            this._groupId = builder.getGroupId();
            this._packetCount = builder.getPacketCount();
            this._refCount = builder.getRefCount();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public List<BucketStats> getBucketStats() {
            return this._bucketStats;
        }

        @Override
        public BigInteger getByteCount() {
            return this._byteCount;
        }

        @Override
        public Long getDurationNsec() {
            return this._durationNsec;
        }

        @Override
        public Long getDurationSec() {
            return this._durationSec;
        }

        @Override
        public GroupId getGroupId() {
            return this._groupId;
        }

        @Override
        public BigInteger getPacketCount() {
            return this._packetCount;
        }

        @Override
        public Long getRefCount() {
            return this._refCount;
        }

        public <E extends Augmentation<GroupStats>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._bucketStats == null ? 0 : this._bucketStats.hashCode());
            result = 31 * result + (this._byteCount == null ? 0 : this._byteCount.hashCode());
            result = 31 * result + (this._durationNsec == null ? 0 : this._durationNsec.hashCode());
            result = 31 * result + (this._durationSec == null ? 0 : this._durationSec.hashCode());
            result = 31 * result + (this._groupId == null ? 0 : this._groupId.hashCode());
            result = 31 * result + (this._packetCount == null ? 0 : this._packetCount.hashCode());
            result = 31 * result + (this._refCount == null ? 0 : this._refCount.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GroupStatsImpl other = (GroupStatsImpl)obj;
            if (this._bucketStats == null ? other._bucketStats != null : !this._bucketStats.equals(other._bucketStats)) {
                return false;
            }
            if (this._byteCount == null ? other._byteCount != null : !this._byteCount.equals(other._byteCount)) {
                return false;
            }
            if (this._durationNsec == null ? other._durationNsec != null : !this._durationNsec.equals(other._durationNsec)) {
                return false;
            }
            if (this._durationSec == null ? other._durationSec != null : !this._durationSec.equals(other._durationSec)) {
                return false;
            }
            if (this._groupId == null ? other._groupId != null : !this._groupId.equals(other._groupId)) {
                return false;
            }
            if (this._packetCount == null ? other._packetCount != null : !this._packetCount.equals(other._packetCount)) {
                return false;
            }
            if (this._refCount == null ? other._refCount != null : !this._refCount.equals(other._refCount)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("GroupStats [_bucketStats=");
            builder.append(this._bucketStats);
            builder.append(", _byteCount=");
            builder.append(this._byteCount);
            builder.append(", _durationNsec=");
            builder.append(this._durationNsec);
            builder.append(", _durationSec=");
            builder.append(this._durationSec);
            builder.append(", _groupId=");
            builder.append(this._groupId);
            builder.append(", _packetCount=");
            builder.append(this._packetCount);
            builder.append(", _refCount=");
            builder.append(this._refCount);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

