/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.flow._case.multipart.reply.flow;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.Actions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions.ActionsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.Instructions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowModFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.MatchV10Grouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.match.v10.grouping.MatchV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MatchGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.match.grouping.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.flow._case.multipart.reply.flow.FlowStats;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class FlowStatsBuilder {
    private BigInteger _byteCount;
    private BigInteger _cookie;
    private Long _durationNsec;
    private Long _durationSec;
    private FlowModFlags _flags;
    private Integer _hardTimeout;
    private Integer _idleTimeout;
    private BigInteger _packetCount;
    private Integer _priority;
    private Short _tableId;
    private List<org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.Instructions> _instructions;
    private List<ActionsList> _actionsList;
    private MatchV10 _matchV10;
    private Match _match;
    private Map<Class<? extends Augmentation<FlowStats>>, Augmentation<FlowStats>> augmentation = new HashMap<Class<? extends Augmentation<FlowStats>>, Augmentation<FlowStats>>();

    public FlowStatsBuilder() {
    }

    public FlowStatsBuilder(Instructions arg) {
        this._instructions = arg.getInstructions();
    }

    public FlowStatsBuilder(Actions arg) {
        this._actionsList = arg.getActionsList();
    }

    public FlowStatsBuilder(MatchV10Grouping arg) {
        this._matchV10 = arg.getMatchV10();
    }

    public FlowStatsBuilder(MatchGrouping arg) {
        this._match = arg.getMatch();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Actions) {
            this._actionsList = ((Actions)arg).getActionsList();
            isValidArg = true;
        }
        if (arg instanceof Instructions) {
            this._instructions = ((Instructions)arg).getInstructions();
            isValidArg = true;
        }
        if (arg instanceof MatchGrouping) {
            this._match = ((MatchGrouping)arg).getMatch();
            isValidArg = true;
        }
        if (arg instanceof MatchV10Grouping) {
            this._matchV10 = ((MatchV10Grouping)arg).getMatchV10();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.Actions, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.Instructions, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MatchGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.MatchV10Grouping] \nbut was: " + arg);
        }
    }

    public BigInteger getByteCount() {
        return this._byteCount;
    }

    public BigInteger getCookie() {
        return this._cookie;
    }

    public Long getDurationNsec() {
        return this._durationNsec;
    }

    public Long getDurationSec() {
        return this._durationSec;
    }

    public FlowModFlags getFlags() {
        return this._flags;
    }

    public Integer getHardTimeout() {
        return this._hardTimeout;
    }

    public Integer getIdleTimeout() {
        return this._idleTimeout;
    }

    public BigInteger getPacketCount() {
        return this._packetCount;
    }

    public Integer getPriority() {
        return this._priority;
    }

    public Short getTableId() {
        return this._tableId;
    }

    public List<org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.Instructions> getInstructions() {
        return this._instructions;
    }

    public List<ActionsList> getActionsList() {
        return this._actionsList;
    }

    public MatchV10 getMatchV10() {
        return this._matchV10;
    }

    public Match getMatch() {
        return this._match;
    }

    public <E extends Augmentation<FlowStats>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public FlowStatsBuilder setByteCount(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._byteCount = value;
        return this;
    }

    public FlowStatsBuilder setCookie(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._cookie = value;
        return this;
    }

    public FlowStatsBuilder setDurationNsec(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._durationNsec = value;
        return this;
    }

    public FlowStatsBuilder setDurationSec(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._durationSec = value;
        return this;
    }

    public FlowStatsBuilder setFlags(FlowModFlags value) {
        this._flags = value;
        return this;
    }

    public FlowStatsBuilder setHardTimeout(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._hardTimeout = value;
        return this;
    }

    public FlowStatsBuilder setIdleTimeout(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._idleTimeout = value;
        return this;
    }

    public FlowStatsBuilder setPacketCount(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._packetCount = value;
        return this;
    }

    public FlowStatsBuilder setPriority(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._priority = value;
        return this;
    }

    public FlowStatsBuilder setTableId(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._tableId = value;
        return this;
    }

    public FlowStatsBuilder setInstructions(List<org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.Instructions> value) {
        this._instructions = value;
        return this;
    }

    public FlowStatsBuilder setActionsList(List<ActionsList> value) {
        this._actionsList = value;
        return this;
    }

    public FlowStatsBuilder setMatchV10(MatchV10 value) {
        this._matchV10 = value;
        return this;
    }

    public FlowStatsBuilder setMatch(Match value) {
        this._match = value;
        return this;
    }

    public FlowStatsBuilder addAugmentation(Class<? extends Augmentation<FlowStats>> augmentationType, Augmentation<FlowStats> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public FlowStats build() {
        return new FlowStatsImpl(this);
    }

    private static final class FlowStatsImpl
    implements FlowStats {
        private final BigInteger _byteCount;
        private final BigInteger _cookie;
        private final Long _durationNsec;
        private final Long _durationSec;
        private final FlowModFlags _flags;
        private final Integer _hardTimeout;
        private final Integer _idleTimeout;
        private final BigInteger _packetCount;
        private final Integer _priority;
        private final Short _tableId;
        private final List<org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.Instructions> _instructions;
        private final List<ActionsList> _actionsList;
        private final MatchV10 _matchV10;
        private final Match _match;
        private Map<Class<? extends Augmentation<FlowStats>>, Augmentation<FlowStats>> augmentation = new HashMap<Class<? extends Augmentation<FlowStats>>, Augmentation<FlowStats>>();

        public Class<FlowStats> getImplementedInterface() {
            return FlowStats.class;
        }

        private FlowStatsImpl(FlowStatsBuilder builder) {
            this._byteCount = builder.getByteCount();
            this._cookie = builder.getCookie();
            this._durationNsec = builder.getDurationNsec();
            this._durationSec = builder.getDurationSec();
            this._flags = builder.getFlags();
            this._hardTimeout = builder.getHardTimeout();
            this._idleTimeout = builder.getIdleTimeout();
            this._packetCount = builder.getPacketCount();
            this._priority = builder.getPriority();
            this._tableId = builder.getTableId();
            this._instructions = builder.getInstructions();
            this._actionsList = builder.getActionsList();
            this._matchV10 = builder.getMatchV10();
            this._match = builder.getMatch();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public BigInteger getByteCount() {
            return this._byteCount;
        }

        @Override
        public BigInteger getCookie() {
            return this._cookie;
        }

        @Override
        public Long getDurationNsec() {
            return this._durationNsec;
        }

        @Override
        public Long getDurationSec() {
            return this._durationSec;
        }

        @Override
        public FlowModFlags getFlags() {
            return this._flags;
        }

        @Override
        public Integer getHardTimeout() {
            return this._hardTimeout;
        }

        @Override
        public Integer getIdleTimeout() {
            return this._idleTimeout;
        }

        @Override
        public BigInteger getPacketCount() {
            return this._packetCount;
        }

        @Override
        public Integer getPriority() {
            return this._priority;
        }

        @Override
        public Short getTableId() {
            return this._tableId;
        }

        @Override
        public List<org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.Instructions> getInstructions() {
            return this._instructions;
        }

        @Override
        public List<ActionsList> getActionsList() {
            return this._actionsList;
        }

        @Override
        public MatchV10 getMatchV10() {
            return this._matchV10;
        }

        @Override
        public Match getMatch() {
            return this._match;
        }

        public <E extends Augmentation<FlowStats>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._byteCount == null ? 0 : this._byteCount.hashCode());
            result = 31 * result + (this._cookie == null ? 0 : this._cookie.hashCode());
            result = 31 * result + (this._durationNsec == null ? 0 : this._durationNsec.hashCode());
            result = 31 * result + (this._durationSec == null ? 0 : this._durationSec.hashCode());
            result = 31 * result + (this._flags == null ? 0 : this._flags.hashCode());
            result = 31 * result + (this._hardTimeout == null ? 0 : this._hardTimeout.hashCode());
            result = 31 * result + (this._idleTimeout == null ? 0 : this._idleTimeout.hashCode());
            result = 31 * result + (this._packetCount == null ? 0 : this._packetCount.hashCode());
            result = 31 * result + (this._priority == null ? 0 : this._priority.hashCode());
            result = 31 * result + (this._tableId == null ? 0 : this._tableId.hashCode());
            result = 31 * result + (this._instructions == null ? 0 : this._instructions.hashCode());
            result = 31 * result + (this._actionsList == null ? 0 : this._actionsList.hashCode());
            result = 31 * result + (this._matchV10 == null ? 0 : this._matchV10.hashCode());
            result = 31 * result + (this._match == null ? 0 : this._match.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FlowStatsImpl other = (FlowStatsImpl)obj;
            if (this._byteCount == null ? other._byteCount != null : !this._byteCount.equals(other._byteCount)) {
                return false;
            }
            if (this._cookie == null ? other._cookie != null : !this._cookie.equals(other._cookie)) {
                return false;
            }
            if (this._durationNsec == null ? other._durationNsec != null : !this._durationNsec.equals(other._durationNsec)) {
                return false;
            }
            if (this._durationSec == null ? other._durationSec != null : !this._durationSec.equals(other._durationSec)) {
                return false;
            }
            if (this._flags == null ? other._flags != null : !this._flags.equals(other._flags)) {
                return false;
            }
            if (this._hardTimeout == null ? other._hardTimeout != null : !this._hardTimeout.equals(other._hardTimeout)) {
                return false;
            }
            if (this._idleTimeout == null ? other._idleTimeout != null : !this._idleTimeout.equals(other._idleTimeout)) {
                return false;
            }
            if (this._packetCount == null ? other._packetCount != null : !this._packetCount.equals(other._packetCount)) {
                return false;
            }
            if (this._priority == null ? other._priority != null : !this._priority.equals(other._priority)) {
                return false;
            }
            if (this._tableId == null ? other._tableId != null : !this._tableId.equals(other._tableId)) {
                return false;
            }
            if (this._instructions == null ? other._instructions != null : !this._instructions.equals(other._instructions)) {
                return false;
            }
            if (this._actionsList == null ? other._actionsList != null : !this._actionsList.equals(other._actionsList)) {
                return false;
            }
            if (this._matchV10 == null ? other._matchV10 != null : !this._matchV10.equals(other._matchV10)) {
                return false;
            }
            if (this._match == null ? other._match != null : !this._match.equals(other._match)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("FlowStats [_byteCount=");
            builder.append(this._byteCount);
            builder.append(", _cookie=");
            builder.append(this._cookie);
            builder.append(", _durationNsec=");
            builder.append(this._durationNsec);
            builder.append(", _durationSec=");
            builder.append(this._durationSec);
            builder.append(", _flags=");
            builder.append(this._flags);
            builder.append(", _hardTimeout=");
            builder.append(this._hardTimeout);
            builder.append(", _idleTimeout=");
            builder.append(this._idleTimeout);
            builder.append(", _packetCount=");
            builder.append(this._packetCount);
            builder.append(", _priority=");
            builder.append(this._priority);
            builder.append(", _tableId=");
            builder.append(this._tableId);
            builder.append(", _instructions=");
            builder.append(this._instructions);
            builder.append(", _actionsList=");
            builder.append(this._actionsList);
            builder.append(", _matchV10=");
            builder.append(this._matchV10);
            builder.append(", _match=");
            builder.append(this._match);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

