/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.match.grouping;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MatchTypeBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.OxmFields;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.oxm.fields.MatchEntries;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.match.grouping.Match;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MatchBuilder {
    private Class<? extends MatchTypeBase> _type;
    private List<MatchEntries> _matchEntries;
    private Map<Class<? extends Augmentation<Match>>, Augmentation<Match>> augmentation = new HashMap<Class<? extends Augmentation<Match>>, Augmentation<Match>>();

    public MatchBuilder() {
    }

    public MatchBuilder(OxmFields arg) {
        this._matchEntries = arg.getMatchEntries();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OxmFields) {
            this._matchEntries = ((OxmFields)arg).getMatchEntries();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.OxmFields] \nbut was: " + arg);
        }
    }

    public Class<? extends MatchTypeBase> getType() {
        return this._type;
    }

    public List<MatchEntries> getMatchEntries() {
        return this._matchEntries;
    }

    public <E extends Augmentation<Match>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MatchBuilder setType(Class<? extends MatchTypeBase> value) {
        this._type = value;
        return this;
    }

    public MatchBuilder setMatchEntries(List<MatchEntries> value) {
        this._matchEntries = value;
        return this;
    }

    public MatchBuilder addAugmentation(Class<? extends Augmentation<Match>> augmentationType, Augmentation<Match> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Match build() {
        return new MatchImpl(this);
    }

    private static final class MatchImpl
    implements Match {
        private final Class<? extends MatchTypeBase> _type;
        private final List<MatchEntries> _matchEntries;
        private Map<Class<? extends Augmentation<Match>>, Augmentation<Match>> augmentation = new HashMap<Class<? extends Augmentation<Match>>, Augmentation<Match>>();

        public Class<Match> getImplementedInterface() {
            return Match.class;
        }

        private MatchImpl(MatchBuilder builder) {
            this._type = builder.getType();
            this._matchEntries = builder.getMatchEntries();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Class<? extends MatchTypeBase> getType() {
            return this._type;
        }

        @Override
        public List<MatchEntries> getMatchEntries() {
            return this._matchEntries;
        }

        public <E extends Augmentation<Match>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._type == null ? 0 : this._type.hashCode());
            result = 31 * result + (this._matchEntries == null ? 0 : this._matchEntries.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MatchImpl other = (MatchImpl)obj;
            if (this._type == null ? other._type != null : !this._type.equals(other._type)) {
                return false;
            }
            if (this._matchEntries == null ? other._matchEntries != null : !this._matchEntries.equals(other._matchEntries)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Match [_type=");
            builder.append(this._type);
            builder.append(", _matchEntries=");
            builder.append(this._matchEntries);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

