/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.hello;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.HelloElementType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHelloElementHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.hello.Elements;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ElementsBuilder {
    private List<Boolean> _versionBitmap;
    private HelloElementType _type;
    private Map<Class<? extends Augmentation<Elements>>, Augmentation<Elements>> augmentation = new HashMap<Class<? extends Augmentation<Elements>>, Augmentation<Elements>>();

    public ElementsBuilder() {
    }

    public ElementsBuilder(OfHelloElementHeader arg) {
        this._type = arg.getType();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OfHelloElementHeader) {
            this._type = ((OfHelloElementHeader)arg).getType();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHelloElementHeader] \nbut was: " + arg);
        }
    }

    public List<Boolean> getVersionBitmap() {
        return this._versionBitmap;
    }

    public HelloElementType getType() {
        return this._type;
    }

    public <E extends Augmentation<Elements>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ElementsBuilder setVersionBitmap(List<Boolean> value) {
        this._versionBitmap = value;
        return this;
    }

    public ElementsBuilder setType(HelloElementType value) {
        this._type = value;
        return this;
    }

    public ElementsBuilder addAugmentation(Class<? extends Augmentation<Elements>> augmentationType, Augmentation<Elements> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Elements build() {
        return new ElementsImpl(this);
    }

    private static final class ElementsImpl
    implements Elements {
        private final List<Boolean> _versionBitmap;
        private final HelloElementType _type;
        private Map<Class<? extends Augmentation<Elements>>, Augmentation<Elements>> augmentation = new HashMap<Class<? extends Augmentation<Elements>>, Augmentation<Elements>>();

        public Class<Elements> getImplementedInterface() {
            return Elements.class;
        }

        private ElementsImpl(ElementsBuilder builder) {
            this._versionBitmap = builder.getVersionBitmap();
            this._type = builder.getType();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public List<Boolean> getVersionBitmap() {
            return this._versionBitmap;
        }

        @Override
        public HelloElementType getType() {
            return this._type;
        }

        public <E extends Augmentation<Elements>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._versionBitmap == null ? 0 : this._versionBitmap.hashCode());
            result = 31 * result + (this._type == null ? 0 : this._type.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ElementsImpl other = (ElementsImpl)obj;
            if (this._versionBitmap == null ? other._versionBitmap != null : !this._versionBitmap.equals(other._versionBitmap)) {
                return false;
            }
            if (this._type == null ? other._type != null : !this._type.equals((Object)other._type)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Elements [_versionBitmap=");
            builder.append(this._versionBitmap);
            builder.append(", _type=");
            builder.append((Object)this._type);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

