/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.buckets;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.Actions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions.ActionsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.Bucket;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.buckets.BucketsList;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class BucketsListBuilder {
    private Long _watchGroup;
    private PortNumber _watchPort;
    private Integer _weight;
    private List<ActionsList> _actionsList;
    private Map<Class<? extends Augmentation<BucketsList>>, Augmentation<BucketsList>> augmentation = new HashMap<Class<? extends Augmentation<BucketsList>>, Augmentation<BucketsList>>();

    public BucketsListBuilder() {
    }

    public BucketsListBuilder(Bucket arg) {
        this._watchGroup = arg.getWatchGroup();
        this._watchPort = arg.getWatchPort();
        this._weight = arg.getWeight();
        this._actionsList = arg.getActionsList();
    }

    public BucketsListBuilder(Actions arg) {
        this._actionsList = arg.getActionsList();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Bucket) {
            this._watchGroup = ((Bucket)arg).getWatchGroup();
            this._watchPort = ((Bucket)arg).getWatchPort();
            this._weight = ((Bucket)arg).getWeight();
            isValidArg = true;
        }
        if (arg instanceof Actions) {
            this._actionsList = ((Actions)arg).getActionsList();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.Bucket, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.Actions] \nbut was: " + arg);
        }
    }

    public Long getWatchGroup() {
        return this._watchGroup;
    }

    public PortNumber getWatchPort() {
        return this._watchPort;
    }

    public Integer getWeight() {
        return this._weight;
    }

    public List<ActionsList> getActionsList() {
        return this._actionsList;
    }

    public <E extends Augmentation<BucketsList>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public BucketsListBuilder setWatchGroup(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._watchGroup = value;
        return this;
    }

    public BucketsListBuilder setWatchPort(PortNumber value) {
        this._watchPort = value;
        return this;
    }

    public BucketsListBuilder setWeight(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._weight = value;
        return this;
    }

    public BucketsListBuilder setActionsList(List<ActionsList> value) {
        this._actionsList = value;
        return this;
    }

    public BucketsListBuilder addAugmentation(Class<? extends Augmentation<BucketsList>> augmentationType, Augmentation<BucketsList> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public BucketsList build() {
        return new BucketsListImpl(this);
    }

    private static final class BucketsListImpl
    implements BucketsList {
        private final Long _watchGroup;
        private final PortNumber _watchPort;
        private final Integer _weight;
        private final List<ActionsList> _actionsList;
        private Map<Class<? extends Augmentation<BucketsList>>, Augmentation<BucketsList>> augmentation = new HashMap<Class<? extends Augmentation<BucketsList>>, Augmentation<BucketsList>>();

        public Class<BucketsList> getImplementedInterface() {
            return BucketsList.class;
        }

        private BucketsListImpl(BucketsListBuilder builder) {
            this._watchGroup = builder.getWatchGroup();
            this._watchPort = builder.getWatchPort();
            this._weight = builder.getWeight();
            this._actionsList = builder.getActionsList();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Long getWatchGroup() {
            return this._watchGroup;
        }

        @Override
        public PortNumber getWatchPort() {
            return this._watchPort;
        }

        @Override
        public Integer getWeight() {
            return this._weight;
        }

        @Override
        public List<ActionsList> getActionsList() {
            return this._actionsList;
        }

        public <E extends Augmentation<BucketsList>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._watchGroup == null ? 0 : this._watchGroup.hashCode());
            result = 31 * result + (this._watchPort == null ? 0 : this._watchPort.hashCode());
            result = 31 * result + (this._weight == null ? 0 : this._weight.hashCode());
            result = 31 * result + (this._actionsList == null ? 0 : this._actionsList.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BucketsListImpl other = (BucketsListImpl)obj;
            if (this._watchGroup == null ? other._watchGroup != null : !this._watchGroup.equals(other._watchGroup)) {
                return false;
            }
            if (this._watchPort == null ? other._watchPort != null : !this._watchPort.equals(other._watchPort)) {
                return false;
            }
            if (this._weight == null ? other._weight != null : !this._weight.equals(other._weight)) {
                return false;
            }
            if (this._actionsList == null ? other._actionsList != null : !this._actionsList.equals(other._actionsList)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("BucketsList [_watchGroup=");
            builder.append(this._watchGroup);
            builder.append(", _watchPort=");
            builder.append(this._watchPort);
            builder.append(", _weight=");
            builder.append(this._weight);
            builder.append(", _actionsList=");
            builder.append(this._actionsList);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

