/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PacketInReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.PacketInMask;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class PacketInMaskBuilder {
    private List<PacketInReason> _mask;
    private Map<Class<? extends Augmentation<PacketInMask>>, Augmentation<PacketInMask>> augmentation = new HashMap<Class<? extends Augmentation<PacketInMask>>, Augmentation<PacketInMask>>();

    public List<PacketInReason> getMask() {
        return this._mask;
    }

    public <E extends Augmentation<PacketInMask>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PacketInMaskBuilder setMask(List<PacketInReason> value) {
        this._mask = value;
        return this;
    }

    public PacketInMaskBuilder addAugmentation(Class<? extends Augmentation<PacketInMask>> augmentationType, Augmentation<PacketInMask> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PacketInMask build() {
        return new PacketInMaskImpl(this);
    }

    private static final class PacketInMaskImpl
    implements PacketInMask {
        private final List<PacketInReason> _mask;
        private Map<Class<? extends Augmentation<PacketInMask>>, Augmentation<PacketInMask>> augmentation = new HashMap<Class<? extends Augmentation<PacketInMask>>, Augmentation<PacketInMask>>();

        public Class<PacketInMask> getImplementedInterface() {
            return PacketInMask.class;
        }

        private PacketInMaskImpl(PacketInMaskBuilder builder) {
            this._mask = builder.getMask();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public List<PacketInReason> getMask() {
            return this._mask;
        }

        public <E extends Augmentation<PacketInMask>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._mask == null ? 0 : this._mask.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PacketInMaskImpl other = (PacketInMaskImpl)obj;
            if (this._mask == null ? other._mask != null : !this._mask.equals(other._mask)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("PacketInMask [_mask=");
            builder.append(this._mask);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

