/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ControllerRole;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.RoleRequest;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.RoleRequestInput;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RoleRequestInputBuilder {
    private BigInteger _generationId;
    private ControllerRole _role;
    private Short _version;
    private Long _xid;
    private Map<Class<? extends Augmentation<RoleRequestInput>>, Augmentation<RoleRequestInput>> augmentation = new HashMap<Class<? extends Augmentation<RoleRequestInput>>, Augmentation<RoleRequestInput>>();

    public RoleRequestInputBuilder() {
    }

    public RoleRequestInputBuilder(RoleRequest arg) {
        this._generationId = arg.getGenerationId();
        this._role = arg.getRole();
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public RoleRequestInputBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (arg instanceof RoleRequest) {
            this._generationId = ((RoleRequest)arg).getGenerationId();
            this._role = ((RoleRequest)arg).getRole();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.RoleRequest] \nbut was: " + arg);
        }
    }

    public BigInteger getGenerationId() {
        return this._generationId;
    }

    public ControllerRole getRole() {
        return this._role;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<RoleRequestInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public RoleRequestInputBuilder setGenerationId(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._generationId = value;
        return this;
    }

    public RoleRequestInputBuilder setRole(ControllerRole value) {
        this._role = value;
        return this;
    }

    public RoleRequestInputBuilder setVersion(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._version = value;
        return this;
    }

    public RoleRequestInputBuilder setXid(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._xid = value;
        return this;
    }

    public RoleRequestInputBuilder addAugmentation(Class<? extends Augmentation<RoleRequestInput>> augmentationType, Augmentation<RoleRequestInput> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public RoleRequestInput build() {
        return new RoleRequestInputImpl(this);
    }

    private static final class RoleRequestInputImpl
    implements RoleRequestInput {
        private final BigInteger _generationId;
        private final ControllerRole _role;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<RoleRequestInput>>, Augmentation<RoleRequestInput>> augmentation = new HashMap<Class<? extends Augmentation<RoleRequestInput>>, Augmentation<RoleRequestInput>>();

        public Class<RoleRequestInput> getImplementedInterface() {
            return RoleRequestInput.class;
        }

        private RoleRequestInputImpl(RoleRequestInputBuilder builder) {
            this._generationId = builder.getGenerationId();
            this._role = builder.getRole();
            this._version = builder.getVersion();
            this._xid = builder.getXid();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public BigInteger getGenerationId() {
            return this._generationId;
        }

        @Override
        public ControllerRole getRole() {
            return this._role;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<RoleRequestInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._generationId == null ? 0 : this._generationId.hashCode());
            result = 31 * result + (this._role == null ? 0 : this._role.hashCode());
            result = 31 * result + (this._version == null ? 0 : this._version.hashCode());
            result = 31 * result + (this._xid == null ? 0 : this._xid.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RoleRequestInputImpl other = (RoleRequestInputImpl)obj;
            if (this._generationId == null ? other._generationId != null : !this._generationId.equals(other._generationId)) {
                return false;
            }
            if (this._role == null ? other._role != null : !this._role.equals((Object)other._role)) {
                return false;
            }
            if (this._version == null ? other._version != null : !this._version.equals(other._version)) {
                return false;
            }
            if (this._xid == null ? other._xid != null : !this._xid.equals(other._xid)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("RoleRequestInput [_generationId=");
            builder.append(this._generationId);
            builder.append(", _role=");
            builder.append((Object)this._role);
            builder.append(", _version=");
            builder.append(this._version);
            builder.append(", _xid=");
            builder.append(this._xid);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

