/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfigV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeaturesV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortMod;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortModInput;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PortModInputBuilder {
    private PortFeatures _advertise;
    private PortFeaturesV10 _advertiseV10;
    private PortConfig _config;
    private PortConfigV10 _configV10;
    private MacAddress _hwAddress;
    private PortConfig _mask;
    private PortConfigV10 _maskV10;
    private PortNumber _portNo;
    private Short _version;
    private Long _xid;
    private Map<Class<? extends Augmentation<PortModInput>>, Augmentation<PortModInput>> augmentation = new HashMap<Class<? extends Augmentation<PortModInput>>, Augmentation<PortModInput>>();

    public PortModInputBuilder() {
    }

    public PortModInputBuilder(PortMod arg) {
        this._advertise = arg.getAdvertise();
        this._advertiseV10 = arg.getAdvertiseV10();
        this._config = arg.getConfig();
        this._configV10 = arg.getConfigV10();
        this._hwAddress = arg.getHwAddress();
        this._mask = arg.getMask();
        this._maskV10 = arg.getMaskV10();
        this._portNo = arg.getPortNo();
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public PortModInputBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (arg instanceof PortMod) {
            this._advertise = ((PortMod)arg).getAdvertise();
            this._advertiseV10 = ((PortMod)arg).getAdvertiseV10();
            this._config = ((PortMod)arg).getConfig();
            this._configV10 = ((PortMod)arg).getConfigV10();
            this._hwAddress = ((PortMod)arg).getHwAddress();
            this._mask = ((PortMod)arg).getMask();
            this._maskV10 = ((PortMod)arg).getMaskV10();
            this._portNo = ((PortMod)arg).getPortNo();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortMod] \nbut was: " + arg);
        }
    }

    public PortFeatures getAdvertise() {
        return this._advertise;
    }

    public PortFeaturesV10 getAdvertiseV10() {
        return this._advertiseV10;
    }

    public PortConfig getConfig() {
        return this._config;
    }

    public PortConfigV10 getConfigV10() {
        return this._configV10;
    }

    public MacAddress getHwAddress() {
        return this._hwAddress;
    }

    public PortConfig getMask() {
        return this._mask;
    }

    public PortConfigV10 getMaskV10() {
        return this._maskV10;
    }

    public PortNumber getPortNo() {
        return this._portNo;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<PortModInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PortModInputBuilder setAdvertise(PortFeatures value) {
        this._advertise = value;
        return this;
    }

    public PortModInputBuilder setAdvertiseV10(PortFeaturesV10 value) {
        this._advertiseV10 = value;
        return this;
    }

    public PortModInputBuilder setConfig(PortConfig value) {
        this._config = value;
        return this;
    }

    public PortModInputBuilder setConfigV10(PortConfigV10 value) {
        this._configV10 = value;
        return this;
    }

    public PortModInputBuilder setHwAddress(MacAddress value) {
        this._hwAddress = value;
        return this;
    }

    public PortModInputBuilder setMask(PortConfig value) {
        this._mask = value;
        return this;
    }

    public PortModInputBuilder setMaskV10(PortConfigV10 value) {
        this._maskV10 = value;
        return this;
    }

    public PortModInputBuilder setPortNo(PortNumber value) {
        this._portNo = value;
        return this;
    }

    public PortModInputBuilder setVersion(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._version = value;
        return this;
    }

    public PortModInputBuilder setXid(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._xid = value;
        return this;
    }

    public PortModInputBuilder addAugmentation(Class<? extends Augmentation<PortModInput>> augmentationType, Augmentation<PortModInput> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PortModInput build() {
        return new PortModInputImpl(this);
    }

    private static final class PortModInputImpl
    implements PortModInput {
        private final PortFeatures _advertise;
        private final PortFeaturesV10 _advertiseV10;
        private final PortConfig _config;
        private final PortConfigV10 _configV10;
        private final MacAddress _hwAddress;
        private final PortConfig _mask;
        private final PortConfigV10 _maskV10;
        private final PortNumber _portNo;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<PortModInput>>, Augmentation<PortModInput>> augmentation = new HashMap<Class<? extends Augmentation<PortModInput>>, Augmentation<PortModInput>>();

        public Class<PortModInput> getImplementedInterface() {
            return PortModInput.class;
        }

        private PortModInputImpl(PortModInputBuilder builder) {
            this._advertise = builder.getAdvertise();
            this._advertiseV10 = builder.getAdvertiseV10();
            this._config = builder.getConfig();
            this._configV10 = builder.getConfigV10();
            this._hwAddress = builder.getHwAddress();
            this._mask = builder.getMask();
            this._maskV10 = builder.getMaskV10();
            this._portNo = builder.getPortNo();
            this._version = builder.getVersion();
            this._xid = builder.getXid();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public PortFeatures getAdvertise() {
            return this._advertise;
        }

        @Override
        public PortFeaturesV10 getAdvertiseV10() {
            return this._advertiseV10;
        }

        @Override
        public PortConfig getConfig() {
            return this._config;
        }

        @Override
        public PortConfigV10 getConfigV10() {
            return this._configV10;
        }

        @Override
        public MacAddress getHwAddress() {
            return this._hwAddress;
        }

        @Override
        public PortConfig getMask() {
            return this._mask;
        }

        @Override
        public PortConfigV10 getMaskV10() {
            return this._maskV10;
        }

        @Override
        public PortNumber getPortNo() {
            return this._portNo;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<PortModInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._advertise == null ? 0 : this._advertise.hashCode());
            result = 31 * result + (this._advertiseV10 == null ? 0 : this._advertiseV10.hashCode());
            result = 31 * result + (this._config == null ? 0 : this._config.hashCode());
            result = 31 * result + (this._configV10 == null ? 0 : this._configV10.hashCode());
            result = 31 * result + (this._hwAddress == null ? 0 : this._hwAddress.hashCode());
            result = 31 * result + (this._mask == null ? 0 : this._mask.hashCode());
            result = 31 * result + (this._maskV10 == null ? 0 : this._maskV10.hashCode());
            result = 31 * result + (this._portNo == null ? 0 : this._portNo.hashCode());
            result = 31 * result + (this._version == null ? 0 : this._version.hashCode());
            result = 31 * result + (this._xid == null ? 0 : this._xid.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PortModInputImpl other = (PortModInputImpl)obj;
            if (this._advertise == null ? other._advertise != null : !this._advertise.equals(other._advertise)) {
                return false;
            }
            if (this._advertiseV10 == null ? other._advertiseV10 != null : !this._advertiseV10.equals(other._advertiseV10)) {
                return false;
            }
            if (this._config == null ? other._config != null : !this._config.equals(other._config)) {
                return false;
            }
            if (this._configV10 == null ? other._configV10 != null : !this._configV10.equals(other._configV10)) {
                return false;
            }
            if (this._hwAddress == null ? other._hwAddress != null : !this._hwAddress.equals((Object)other._hwAddress)) {
                return false;
            }
            if (this._mask == null ? other._mask != null : !this._mask.equals(other._mask)) {
                return false;
            }
            if (this._maskV10 == null ? other._maskV10 != null : !this._maskV10.equals(other._maskV10)) {
                return false;
            }
            if (this._portNo == null ? other._portNo != null : !this._portNo.equals(other._portNo)) {
                return false;
            }
            if (this._version == null ? other._version != null : !this._version.equals(other._version)) {
                return false;
            }
            if (this._xid == null ? other._xid != null : !this._xid.equals(other._xid)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("PortModInput [_advertise=");
            builder.append(this._advertise);
            builder.append(", _advertiseV10=");
            builder.append(this._advertiseV10);
            builder.append(", _config=");
            builder.append(this._config);
            builder.append(", _configV10=");
            builder.append(this._configV10);
            builder.append(", _hwAddress=");
            builder.append(this._hwAddress);
            builder.append(", _mask=");
            builder.append(this._mask);
            builder.append(", _maskV10=");
            builder.append(this._maskV10);
            builder.append(", _portNo=");
            builder.append(this._portNo);
            builder.append(", _version=");
            builder.append(this._version);
            builder.append(", _xid=");
            builder.append(this._xid);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

