/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PacketInReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MatchGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketIn;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketInMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.match.grouping.Match;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PacketInMessageBuilder {
    private Long _bufferId;
    private BigInteger _cookie;
    private byte[] _data;
    private Integer _inPort;
    private PacketInReason _reason;
    private TableId _tableId;
    private Integer _totalLen;
    private Match _match;
    private Short _version;
    private Long _xid;
    private Map<Class<? extends Augmentation<PacketInMessage>>, Augmentation<PacketInMessage>> augmentation = new HashMap<Class<? extends Augmentation<PacketInMessage>>, Augmentation<PacketInMessage>>();

    public PacketInMessageBuilder() {
    }

    public PacketInMessageBuilder(PacketIn arg) {
        this._bufferId = arg.getBufferId();
        this._cookie = arg.getCookie();
        this._data = arg.getData();
        this._inPort = arg.getInPort();
        this._reason = arg.getReason();
        this._tableId = arg.getTableId();
        this._totalLen = arg.getTotalLen();
        this._match = arg.getMatch();
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public PacketInMessageBuilder(MatchGrouping arg) {
        this._match = arg.getMatch();
    }

    public PacketInMessageBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PacketIn) {
            this._bufferId = ((PacketIn)arg).getBufferId();
            this._cookie = ((PacketIn)arg).getCookie();
            this._data = ((PacketIn)arg).getData();
            this._inPort = ((PacketIn)arg).getInPort();
            this._reason = ((PacketIn)arg).getReason();
            this._tableId = ((PacketIn)arg).getTableId();
            this._totalLen = ((PacketIn)arg).getTotalLen();
            isValidArg = true;
        }
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (arg instanceof MatchGrouping) {
            this._match = ((MatchGrouping)arg).getMatch();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketIn, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MatchGrouping] \nbut was: " + arg);
        }
    }

    public Long getBufferId() {
        return this._bufferId;
    }

    public BigInteger getCookie() {
        return this._cookie;
    }

    public byte[] getData() {
        return this._data;
    }

    public Integer getInPort() {
        return this._inPort;
    }

    public PacketInReason getReason() {
        return this._reason;
    }

    public TableId getTableId() {
        return this._tableId;
    }

    public Integer getTotalLen() {
        return this._totalLen;
    }

    public Match getMatch() {
        return this._match;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<PacketInMessage>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PacketInMessageBuilder setBufferId(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._bufferId = value;
        return this;
    }

    public PacketInMessageBuilder setCookie(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._cookie = value;
        return this;
    }

    public PacketInMessageBuilder setData(byte[] value) {
        this._data = value;
        return this;
    }

    public PacketInMessageBuilder setInPort(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._inPort = value;
        return this;
    }

    public PacketInMessageBuilder setReason(PacketInReason value) {
        this._reason = value;
        return this;
    }

    public PacketInMessageBuilder setTableId(TableId value) {
        this._tableId = value;
        return this;
    }

    public PacketInMessageBuilder setTotalLen(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._totalLen = value;
        return this;
    }

    public PacketInMessageBuilder setMatch(Match value) {
        this._match = value;
        return this;
    }

    public PacketInMessageBuilder setVersion(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._version = value;
        return this;
    }

    public PacketInMessageBuilder setXid(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._xid = value;
        return this;
    }

    public PacketInMessageBuilder addAugmentation(Class<? extends Augmentation<PacketInMessage>> augmentationType, Augmentation<PacketInMessage> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PacketInMessage build() {
        return new PacketInMessageImpl(this);
    }

    private static final class PacketInMessageImpl
    implements PacketInMessage {
        private final Long _bufferId;
        private final BigInteger _cookie;
        private final byte[] _data;
        private final Integer _inPort;
        private final PacketInReason _reason;
        private final TableId _tableId;
        private final Integer _totalLen;
        private final Match _match;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<PacketInMessage>>, Augmentation<PacketInMessage>> augmentation = new HashMap<Class<? extends Augmentation<PacketInMessage>>, Augmentation<PacketInMessage>>();

        public Class<PacketInMessage> getImplementedInterface() {
            return PacketInMessage.class;
        }

        private PacketInMessageImpl(PacketInMessageBuilder builder) {
            this._bufferId = builder.getBufferId();
            this._cookie = builder.getCookie();
            this._data = builder.getData();
            this._inPort = builder.getInPort();
            this._reason = builder.getReason();
            this._tableId = builder.getTableId();
            this._totalLen = builder.getTotalLen();
            this._match = builder.getMatch();
            this._version = builder.getVersion();
            this._xid = builder.getXid();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Long getBufferId() {
            return this._bufferId;
        }

        @Override
        public BigInteger getCookie() {
            return this._cookie;
        }

        @Override
        public byte[] getData() {
            return this._data;
        }

        @Override
        public Integer getInPort() {
            return this._inPort;
        }

        @Override
        public PacketInReason getReason() {
            return this._reason;
        }

        @Override
        public TableId getTableId() {
            return this._tableId;
        }

        @Override
        public Integer getTotalLen() {
            return this._totalLen;
        }

        @Override
        public Match getMatch() {
            return this._match;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<PacketInMessage>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._bufferId == null ? 0 : this._bufferId.hashCode());
            result = 31 * result + (this._cookie == null ? 0 : this._cookie.hashCode());
            result = 31 * result + (this._data == null ? 0 : Arrays.hashCode(this._data));
            result = 31 * result + (this._inPort == null ? 0 : this._inPort.hashCode());
            result = 31 * result + (this._reason == null ? 0 : this._reason.hashCode());
            result = 31 * result + (this._tableId == null ? 0 : this._tableId.hashCode());
            result = 31 * result + (this._totalLen == null ? 0 : this._totalLen.hashCode());
            result = 31 * result + (this._match == null ? 0 : this._match.hashCode());
            result = 31 * result + (this._version == null ? 0 : this._version.hashCode());
            result = 31 * result + (this._xid == null ? 0 : this._xid.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PacketInMessageImpl other = (PacketInMessageImpl)obj;
            if (this._bufferId == null ? other._bufferId != null : !this._bufferId.equals(other._bufferId)) {
                return false;
            }
            if (this._cookie == null ? other._cookie != null : !this._cookie.equals(other._cookie)) {
                return false;
            }
            if (this._data == null ? other._data != null : !Arrays.equals(this._data, other._data)) {
                return false;
            }
            if (this._inPort == null ? other._inPort != null : !this._inPort.equals(other._inPort)) {
                return false;
            }
            if (this._reason == null ? other._reason != null : !this._reason.equals((Object)other._reason)) {
                return false;
            }
            if (this._tableId == null ? other._tableId != null : !this._tableId.equals(other._tableId)) {
                return false;
            }
            if (this._totalLen == null ? other._totalLen != null : !this._totalLen.equals(other._totalLen)) {
                return false;
            }
            if (this._match == null ? other._match != null : !this._match.equals(other._match)) {
                return false;
            }
            if (this._version == null ? other._version != null : !this._version.equals(other._version)) {
                return false;
            }
            if (this._xid == null ? other._xid != null : !this._xid.equals(other._xid)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("PacketInMessage [_bufferId=");
            builder.append(this._bufferId);
            builder.append(", _cookie=");
            builder.append(this._cookie);
            builder.append(", _data=");
            builder.append(Arrays.toString(this._data));
            builder.append(", _inPort=");
            builder.append(this._inPort);
            builder.append(", _reason=");
            builder.append((Object)this._reason);
            builder.append(", _tableId=");
            builder.append(this._tableId);
            builder.append(", _totalLen=");
            builder.append(this._totalLen);
            builder.append(", _match=");
            builder.append(this._match);
            builder.append(", _version=");
            builder.append(this._version);
            builder.append(", _xid=");
            builder.append(this._xid);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

