/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartRequestFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequest;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.MultipartRequestBody;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MultipartRequestInputBuilder {
    private MultipartRequestFlags _flags;
    private MultipartRequestBody _multipartRequestBody;
    private MultipartType _type;
    private Short _version;
    private Long _xid;
    private Map<Class<? extends Augmentation<MultipartRequestInput>>, Augmentation<MultipartRequestInput>> augmentation = new HashMap<Class<? extends Augmentation<MultipartRequestInput>>, Augmentation<MultipartRequestInput>>();

    public MultipartRequestInputBuilder() {
    }

    public MultipartRequestInputBuilder(MultipartRequest arg) {
        this._flags = arg.getFlags();
        this._multipartRequestBody = arg.getMultipartRequestBody();
        this._type = arg.getType();
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public MultipartRequestInputBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MultipartRequest) {
            this._flags = ((MultipartRequest)arg).getFlags();
            this._multipartRequestBody = ((MultipartRequest)arg).getMultipartRequestBody();
            this._type = ((MultipartRequest)arg).getType();
            isValidArg = true;
        }
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequest, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader] \nbut was: " + arg);
        }
    }

    public MultipartRequestFlags getFlags() {
        return this._flags;
    }

    public MultipartRequestBody getMultipartRequestBody() {
        return this._multipartRequestBody;
    }

    public MultipartType getType() {
        return this._type;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<MultipartRequestInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MultipartRequestInputBuilder setFlags(MultipartRequestFlags value) {
        this._flags = value;
        return this;
    }

    public MultipartRequestInputBuilder setMultipartRequestBody(MultipartRequestBody value) {
        this._multipartRequestBody = value;
        return this;
    }

    public MultipartRequestInputBuilder setType(MultipartType value) {
        this._type = value;
        return this;
    }

    public MultipartRequestInputBuilder setVersion(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._version = value;
        return this;
    }

    public MultipartRequestInputBuilder setXid(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._xid = value;
        return this;
    }

    public MultipartRequestInputBuilder addAugmentation(Class<? extends Augmentation<MultipartRequestInput>> augmentationType, Augmentation<MultipartRequestInput> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MultipartRequestInput build() {
        return new MultipartRequestInputImpl(this);
    }

    private static final class MultipartRequestInputImpl
    implements MultipartRequestInput {
        private final MultipartRequestFlags _flags;
        private final MultipartRequestBody _multipartRequestBody;
        private final MultipartType _type;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<MultipartRequestInput>>, Augmentation<MultipartRequestInput>> augmentation = new HashMap<Class<? extends Augmentation<MultipartRequestInput>>, Augmentation<MultipartRequestInput>>();

        public Class<MultipartRequestInput> getImplementedInterface() {
            return MultipartRequestInput.class;
        }

        private MultipartRequestInputImpl(MultipartRequestInputBuilder builder) {
            this._flags = builder.getFlags();
            this._multipartRequestBody = builder.getMultipartRequestBody();
            this._type = builder.getType();
            this._version = builder.getVersion();
            this._xid = builder.getXid();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public MultipartRequestFlags getFlags() {
            return this._flags;
        }

        @Override
        public MultipartRequestBody getMultipartRequestBody() {
            return this._multipartRequestBody;
        }

        @Override
        public MultipartType getType() {
            return this._type;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<MultipartRequestInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._flags == null ? 0 : this._flags.hashCode());
            result = 31 * result + (this._multipartRequestBody == null ? 0 : this._multipartRequestBody.hashCode());
            result = 31 * result + (this._type == null ? 0 : this._type.hashCode());
            result = 31 * result + (this._version == null ? 0 : this._version.hashCode());
            result = 31 * result + (this._xid == null ? 0 : this._xid.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MultipartRequestInputImpl other = (MultipartRequestInputImpl)obj;
            if (this._flags == null ? other._flags != null : !this._flags.equals(other._flags)) {
                return false;
            }
            if (this._multipartRequestBody == null ? other._multipartRequestBody != null : !this._multipartRequestBody.equals(other._multipartRequestBody)) {
                return false;
            }
            if (this._type == null ? other._type != null : !this._type.equals((Object)other._type)) {
                return false;
            }
            if (this._version == null ? other._version != null : !this._version.equals(other._version)) {
                return false;
            }
            if (this._xid == null ? other._xid != null : !this._xid.equals(other._xid)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MultipartRequestInput [_flags=");
            builder.append(this._flags);
            builder.append(", _multipartRequestBody=");
            builder.append(this._multipartRequestBody);
            builder.append(", _type=");
            builder.append((Object)this._type);
            builder.append(", _version=");
            builder.append(this._version);
            builder.append(", _xid=");
            builder.append(this._xid);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

