/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartRequestFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReply;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReplyMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.MultipartReplyBody;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MultipartReplyMessageBuilder {
    private MultipartRequestFlags _flags;
    private MultipartReplyBody _multipartReplyBody;
    private MultipartType _type;
    private Short _version;
    private Long _xid;
    private Map<Class<? extends Augmentation<MultipartReplyMessage>>, Augmentation<MultipartReplyMessage>> augmentation = new HashMap<Class<? extends Augmentation<MultipartReplyMessage>>, Augmentation<MultipartReplyMessage>>();

    public MultipartReplyMessageBuilder() {
    }

    public MultipartReplyMessageBuilder(MultipartReply arg) {
        this._flags = arg.getFlags();
        this._multipartReplyBody = arg.getMultipartReplyBody();
        this._type = arg.getType();
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public MultipartReplyMessageBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (arg instanceof MultipartReply) {
            this._flags = ((MultipartReply)arg).getFlags();
            this._multipartReplyBody = ((MultipartReply)arg).getMultipartReplyBody();
            this._type = ((MultipartReply)arg).getType();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReply] \nbut was: " + arg);
        }
    }

    public MultipartRequestFlags getFlags() {
        return this._flags;
    }

    public MultipartReplyBody getMultipartReplyBody() {
        return this._multipartReplyBody;
    }

    public MultipartType getType() {
        return this._type;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<MultipartReplyMessage>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MultipartReplyMessageBuilder setFlags(MultipartRequestFlags value) {
        this._flags = value;
        return this;
    }

    public MultipartReplyMessageBuilder setMultipartReplyBody(MultipartReplyBody value) {
        this._multipartReplyBody = value;
        return this;
    }

    public MultipartReplyMessageBuilder setType(MultipartType value) {
        this._type = value;
        return this;
    }

    public MultipartReplyMessageBuilder setVersion(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._version = value;
        return this;
    }

    public MultipartReplyMessageBuilder setXid(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._xid = value;
        return this;
    }

    public MultipartReplyMessageBuilder addAugmentation(Class<? extends Augmentation<MultipartReplyMessage>> augmentationType, Augmentation<MultipartReplyMessage> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MultipartReplyMessage build() {
        return new MultipartReplyMessageImpl(this);
    }

    private static final class MultipartReplyMessageImpl
    implements MultipartReplyMessage {
        private final MultipartRequestFlags _flags;
        private final MultipartReplyBody _multipartReplyBody;
        private final MultipartType _type;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<MultipartReplyMessage>>, Augmentation<MultipartReplyMessage>> augmentation = new HashMap<Class<? extends Augmentation<MultipartReplyMessage>>, Augmentation<MultipartReplyMessage>>();

        public Class<MultipartReplyMessage> getImplementedInterface() {
            return MultipartReplyMessage.class;
        }

        private MultipartReplyMessageImpl(MultipartReplyMessageBuilder builder) {
            this._flags = builder.getFlags();
            this._multipartReplyBody = builder.getMultipartReplyBody();
            this._type = builder.getType();
            this._version = builder.getVersion();
            this._xid = builder.getXid();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public MultipartRequestFlags getFlags() {
            return this._flags;
        }

        @Override
        public MultipartReplyBody getMultipartReplyBody() {
            return this._multipartReplyBody;
        }

        @Override
        public MultipartType getType() {
            return this._type;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<MultipartReplyMessage>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._flags == null ? 0 : this._flags.hashCode());
            result = 31 * result + (this._multipartReplyBody == null ? 0 : this._multipartReplyBody.hashCode());
            result = 31 * result + (this._type == null ? 0 : this._type.hashCode());
            result = 31 * result + (this._version == null ? 0 : this._version.hashCode());
            result = 31 * result + (this._xid == null ? 0 : this._xid.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MultipartReplyMessageImpl other = (MultipartReplyMessageImpl)obj;
            if (this._flags == null ? other._flags != null : !this._flags.equals(other._flags)) {
                return false;
            }
            if (this._multipartReplyBody == null ? other._multipartReplyBody != null : !this._multipartReplyBody.equals(other._multipartReplyBody)) {
                return false;
            }
            if (this._type == null ? other._type != null : !this._type.equals((Object)other._type)) {
                return false;
            }
            if (this._version == null ? other._version != null : !this._version.equals(other._version)) {
                return false;
            }
            if (this._xid == null ? other._xid != null : !this._xid.equals(other._xid)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MultipartReplyMessage [_flags=");
            builder.append(this._flags);
            builder.append(", _multipartReplyBody=");
            builder.append(this._multipartReplyBody);
            builder.append(", _type=");
            builder.append((Object)this._type);
            builder.append(", _version=");
            builder.append(this._version);
            builder.append(", _xid=");
            builder.append(this._xid);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

