/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterModCommand;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MeterMod;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MeterModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.mod.Bands;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MeterModInputBuilder {
    private List<Bands> _bands;
    private MeterModCommand _command;
    private MeterFlags _flags;
    private MeterId _meterId;
    private Short _version;
    private Long _xid;
    private Map<Class<? extends Augmentation<MeterModInput>>, Augmentation<MeterModInput>> augmentation = new HashMap<Class<? extends Augmentation<MeterModInput>>, Augmentation<MeterModInput>>();

    public MeterModInputBuilder() {
    }

    public MeterModInputBuilder(MeterMod arg) {
        this._bands = arg.getBands();
        this._command = arg.getCommand();
        this._flags = arg.getFlags();
        this._meterId = arg.getMeterId();
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public MeterModInputBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (arg instanceof MeterMod) {
            this._bands = ((MeterMod)arg).getBands();
            this._command = ((MeterMod)arg).getCommand();
            this._flags = ((MeterMod)arg).getFlags();
            this._meterId = ((MeterMod)arg).getMeterId();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MeterMod] \nbut was: " + arg);
        }
    }

    public List<Bands> getBands() {
        return this._bands;
    }

    public MeterModCommand getCommand() {
        return this._command;
    }

    public MeterFlags getFlags() {
        return this._flags;
    }

    public MeterId getMeterId() {
        return this._meterId;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<MeterModInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MeterModInputBuilder setBands(List<Bands> value) {
        this._bands = value;
        return this;
    }

    public MeterModInputBuilder setCommand(MeterModCommand value) {
        this._command = value;
        return this;
    }

    public MeterModInputBuilder setFlags(MeterFlags value) {
        this._flags = value;
        return this;
    }

    public MeterModInputBuilder setMeterId(MeterId value) {
        this._meterId = value;
        return this;
    }

    public MeterModInputBuilder setVersion(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._version = value;
        return this;
    }

    public MeterModInputBuilder setXid(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._xid = value;
        return this;
    }

    public MeterModInputBuilder addAugmentation(Class<? extends Augmentation<MeterModInput>> augmentationType, Augmentation<MeterModInput> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MeterModInput build() {
        return new MeterModInputImpl(this);
    }

    private static final class MeterModInputImpl
    implements MeterModInput {
        private final List<Bands> _bands;
        private final MeterModCommand _command;
        private final MeterFlags _flags;
        private final MeterId _meterId;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<MeterModInput>>, Augmentation<MeterModInput>> augmentation = new HashMap<Class<? extends Augmentation<MeterModInput>>, Augmentation<MeterModInput>>();

        public Class<MeterModInput> getImplementedInterface() {
            return MeterModInput.class;
        }

        private MeterModInputImpl(MeterModInputBuilder builder) {
            this._bands = builder.getBands();
            this._command = builder.getCommand();
            this._flags = builder.getFlags();
            this._meterId = builder.getMeterId();
            this._version = builder.getVersion();
            this._xid = builder.getXid();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public List<Bands> getBands() {
            return this._bands;
        }

        @Override
        public MeterModCommand getCommand() {
            return this._command;
        }

        @Override
        public MeterFlags getFlags() {
            return this._flags;
        }

        @Override
        public MeterId getMeterId() {
            return this._meterId;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<MeterModInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._bands == null ? 0 : this._bands.hashCode());
            result = 31 * result + (this._command == null ? 0 : this._command.hashCode());
            result = 31 * result + (this._flags == null ? 0 : this._flags.hashCode());
            result = 31 * result + (this._meterId == null ? 0 : this._meterId.hashCode());
            result = 31 * result + (this._version == null ? 0 : this._version.hashCode());
            result = 31 * result + (this._xid == null ? 0 : this._xid.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MeterModInputImpl other = (MeterModInputImpl)obj;
            if (this._bands == null ? other._bands != null : !this._bands.equals(other._bands)) {
                return false;
            }
            if (this._command == null ? other._command != null : !this._command.equals((Object)other._command)) {
                return false;
            }
            if (this._flags == null ? other._flags != null : !this._flags.equals(other._flags)) {
                return false;
            }
            if (this._meterId == null ? other._meterId != null : !this._meterId.equals(other._meterId)) {
                return false;
            }
            if (this._version == null ? other._version != null : !this._version.equals(other._version)) {
                return false;
            }
            if (this._xid == null ? other._xid != null : !this._xid.equals(other._xid)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MeterModInput [_bands=");
            builder.append(this._bands);
            builder.append(", _command=");
            builder.append((Object)this._command);
            builder.append(", _flags=");
            builder.append(this._flags);
            builder.append(", _meterId=");
            builder.append(this._meterId);
            builder.append(", _version=");
            builder.append(this._version);
            builder.append(", _xid=");
            builder.append(this._xid);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

