/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupModCommand;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.Buckets;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GroupMod;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GroupModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.buckets.BucketsList;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GroupModInputBuilder {
    private GroupModCommand _command;
    private GroupId _groupId;
    private GroupType _type;
    private List<BucketsList> _bucketsList;
    private Short _version;
    private Long _xid;
    private Map<Class<? extends Augmentation<GroupModInput>>, Augmentation<GroupModInput>> augmentation = new HashMap<Class<? extends Augmentation<GroupModInput>>, Augmentation<GroupModInput>>();

    public GroupModInputBuilder() {
    }

    public GroupModInputBuilder(GroupMod arg) {
        this._command = arg.getCommand();
        this._groupId = arg.getGroupId();
        this._type = arg.getType();
        this._bucketsList = arg.getBucketsList();
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public GroupModInputBuilder(Buckets arg) {
        this._bucketsList = arg.getBucketsList();
    }

    public GroupModInputBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Buckets) {
            this._bucketsList = ((Buckets)arg).getBucketsList();
            isValidArg = true;
        }
        if (arg instanceof GroupMod) {
            this._command = ((GroupMod)arg).getCommand();
            this._groupId = ((GroupMod)arg).getGroupId();
            this._type = ((GroupMod)arg).getType();
            isValidArg = true;
        }
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.Buckets, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GroupMod, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader] \nbut was: " + arg);
        }
    }

    public GroupModCommand getCommand() {
        return this._command;
    }

    public GroupId getGroupId() {
        return this._groupId;
    }

    public GroupType getType() {
        return this._type;
    }

    public List<BucketsList> getBucketsList() {
        return this._bucketsList;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<GroupModInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public GroupModInputBuilder setCommand(GroupModCommand value) {
        this._command = value;
        return this;
    }

    public GroupModInputBuilder setGroupId(GroupId value) {
        this._groupId = value;
        return this;
    }

    public GroupModInputBuilder setType(GroupType value) {
        this._type = value;
        return this;
    }

    public GroupModInputBuilder setBucketsList(List<BucketsList> value) {
        this._bucketsList = value;
        return this;
    }

    public GroupModInputBuilder setVersion(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._version = value;
        return this;
    }

    public GroupModInputBuilder setXid(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._xid = value;
        return this;
    }

    public GroupModInputBuilder addAugmentation(Class<? extends Augmentation<GroupModInput>> augmentationType, Augmentation<GroupModInput> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public GroupModInput build() {
        return new GroupModInputImpl(this);
    }

    private static final class GroupModInputImpl
    implements GroupModInput {
        private final GroupModCommand _command;
        private final GroupId _groupId;
        private final GroupType _type;
        private final List<BucketsList> _bucketsList;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<GroupModInput>>, Augmentation<GroupModInput>> augmentation = new HashMap<Class<? extends Augmentation<GroupModInput>>, Augmentation<GroupModInput>>();

        public Class<GroupModInput> getImplementedInterface() {
            return GroupModInput.class;
        }

        private GroupModInputImpl(GroupModInputBuilder builder) {
            this._command = builder.getCommand();
            this._groupId = builder.getGroupId();
            this._type = builder.getType();
            this._bucketsList = builder.getBucketsList();
            this._version = builder.getVersion();
            this._xid = builder.getXid();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public GroupModCommand getCommand() {
            return this._command;
        }

        @Override
        public GroupId getGroupId() {
            return this._groupId;
        }

        @Override
        public GroupType getType() {
            return this._type;
        }

        @Override
        public List<BucketsList> getBucketsList() {
            return this._bucketsList;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<GroupModInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._command == null ? 0 : this._command.hashCode());
            result = 31 * result + (this._groupId == null ? 0 : this._groupId.hashCode());
            result = 31 * result + (this._type == null ? 0 : this._type.hashCode());
            result = 31 * result + (this._bucketsList == null ? 0 : this._bucketsList.hashCode());
            result = 31 * result + (this._version == null ? 0 : this._version.hashCode());
            result = 31 * result + (this._xid == null ? 0 : this._xid.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GroupModInputImpl other = (GroupModInputImpl)obj;
            if (this._command == null ? other._command != null : !this._command.equals((Object)other._command)) {
                return false;
            }
            if (this._groupId == null ? other._groupId != null : !this._groupId.equals(other._groupId)) {
                return false;
            }
            if (this._type == null ? other._type != null : !this._type.equals((Object)other._type)) {
                return false;
            }
            if (this._bucketsList == null ? other._bucketsList != null : !this._bucketsList.equals(other._bucketsList)) {
                return false;
            }
            if (this._version == null ? other._version != null : !this._version.equals(other._version)) {
                return false;
            }
            if (this._xid == null ? other._xid != null : !this._xid.equals(other._xid)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("GroupModInput [_command=");
            builder.append((Object)this._command);
            builder.append(", _groupId=");
            builder.append(this._groupId);
            builder.append(", _type=");
            builder.append((Object)this._type);
            builder.append(", _bucketsList=");
            builder.append(this._bucketsList);
            builder.append(", _version=");
            builder.append(this._version);
            builder.append(", _xid=");
            builder.append(this._xid);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

