/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetQueueConfigOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.QueueGetConfigReply;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.get.config.reply.Queues;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GetQueueConfigOutputBuilder {
    private PortNumber _port;
    private List<Queues> _queues;
    private Short _version;
    private Long _xid;
    private Map<Class<? extends Augmentation<GetQueueConfigOutput>>, Augmentation<GetQueueConfigOutput>> augmentation = new HashMap<Class<? extends Augmentation<GetQueueConfigOutput>>, Augmentation<GetQueueConfigOutput>>();

    public GetQueueConfigOutputBuilder() {
    }

    public GetQueueConfigOutputBuilder(QueueGetConfigReply arg) {
        this._port = arg.getPort();
        this._queues = arg.getQueues();
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public GetQueueConfigOutputBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof QueueGetConfigReply) {
            this._port = ((QueueGetConfigReply)arg).getPort();
            this._queues = ((QueueGetConfigReply)arg).getQueues();
            isValidArg = true;
        }
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.QueueGetConfigReply, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader] \nbut was: " + arg);
        }
    }

    public PortNumber getPort() {
        return this._port;
    }

    public List<Queues> getQueues() {
        return this._queues;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<GetQueueConfigOutput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public GetQueueConfigOutputBuilder setPort(PortNumber value) {
        this._port = value;
        return this;
    }

    public GetQueueConfigOutputBuilder setQueues(List<Queues> value) {
        this._queues = value;
        return this;
    }

    public GetQueueConfigOutputBuilder setVersion(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._version = value;
        return this;
    }

    public GetQueueConfigOutputBuilder setXid(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._xid = value;
        return this;
    }

    public GetQueueConfigOutputBuilder addAugmentation(Class<? extends Augmentation<GetQueueConfigOutput>> augmentationType, Augmentation<GetQueueConfigOutput> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public GetQueueConfigOutput build() {
        return new GetQueueConfigOutputImpl(this);
    }

    private static final class GetQueueConfigOutputImpl
    implements GetQueueConfigOutput {
        private final PortNumber _port;
        private final List<Queues> _queues;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<GetQueueConfigOutput>>, Augmentation<GetQueueConfigOutput>> augmentation = new HashMap<Class<? extends Augmentation<GetQueueConfigOutput>>, Augmentation<GetQueueConfigOutput>>();

        public Class<GetQueueConfigOutput> getImplementedInterface() {
            return GetQueueConfigOutput.class;
        }

        private GetQueueConfigOutputImpl(GetQueueConfigOutputBuilder builder) {
            this._port = builder.getPort();
            this._queues = builder.getQueues();
            this._version = builder.getVersion();
            this._xid = builder.getXid();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public PortNumber getPort() {
            return this._port;
        }

        @Override
        public List<Queues> getQueues() {
            return this._queues;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<GetQueueConfigOutput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._port == null ? 0 : this._port.hashCode());
            result = 31 * result + (this._queues == null ? 0 : this._queues.hashCode());
            result = 31 * result + (this._version == null ? 0 : this._version.hashCode());
            result = 31 * result + (this._xid == null ? 0 : this._xid.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GetQueueConfigOutputImpl other = (GetQueueConfigOutputImpl)obj;
            if (this._port == null ? other._port != null : !this._port.equals(other._port)) {
                return false;
            }
            if (this._queues == null ? other._queues != null : !this._queues.equals(other._queues)) {
                return false;
            }
            if (this._version == null ? other._version != null : !this._version.equals(other._version)) {
                return false;
            }
            if (this._xid == null ? other._xid != null : !this._xid.equals(other._xid)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("GetQueueConfigOutput [_port=");
            builder.append(this._port);
            builder.append(", _queues=");
            builder.append(this._queues);
            builder.append(", _version=");
            builder.append(this._version);
            builder.append(", _xid=");
            builder.append(this._xid);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

