/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ActionTypeV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.Capabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.CapabilitiesV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FeaturesReply;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.features.reply.PhyPort;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GetFeaturesOutputBuilder {
    private ActionTypeV10 _actionsV10;
    private Short _auxiliaryId;
    private Long _buffers;
    private Capabilities _capabilities;
    private CapabilitiesV10 _capabilitiesV10;
    private BigInteger _datapathId;
    private List<PhyPort> _phyPort;
    private Long _reserved;
    private Short _tables;
    private Short _version;
    private Long _xid;
    private Map<Class<? extends Augmentation<GetFeaturesOutput>>, Augmentation<GetFeaturesOutput>> augmentation = new HashMap<Class<? extends Augmentation<GetFeaturesOutput>>, Augmentation<GetFeaturesOutput>>();

    public GetFeaturesOutputBuilder() {
    }

    public GetFeaturesOutputBuilder(FeaturesReply arg) {
        this._actionsV10 = arg.getActionsV10();
        this._auxiliaryId = arg.getAuxiliaryId();
        this._buffers = arg.getBuffers();
        this._capabilities = arg.getCapabilities();
        this._capabilitiesV10 = arg.getCapabilitiesV10();
        this._datapathId = arg.getDatapathId();
        this._phyPort = arg.getPhyPort();
        this._reserved = arg.getReserved();
        this._tables = arg.getTables();
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public GetFeaturesOutputBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (arg instanceof FeaturesReply) {
            this._actionsV10 = ((FeaturesReply)arg).getActionsV10();
            this._auxiliaryId = ((FeaturesReply)arg).getAuxiliaryId();
            this._buffers = ((FeaturesReply)arg).getBuffers();
            this._capabilities = ((FeaturesReply)arg).getCapabilities();
            this._capabilitiesV10 = ((FeaturesReply)arg).getCapabilitiesV10();
            this._datapathId = ((FeaturesReply)arg).getDatapathId();
            this._phyPort = ((FeaturesReply)arg).getPhyPort();
            this._reserved = ((FeaturesReply)arg).getReserved();
            this._tables = ((FeaturesReply)arg).getTables();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FeaturesReply] \nbut was: " + arg);
        }
    }

    public ActionTypeV10 getActionsV10() {
        return this._actionsV10;
    }

    public Short getAuxiliaryId() {
        return this._auxiliaryId;
    }

    public Long getBuffers() {
        return this._buffers;
    }

    public Capabilities getCapabilities() {
        return this._capabilities;
    }

    public CapabilitiesV10 getCapabilitiesV10() {
        return this._capabilitiesV10;
    }

    public BigInteger getDatapathId() {
        return this._datapathId;
    }

    public List<PhyPort> getPhyPort() {
        return this._phyPort;
    }

    public Long getReserved() {
        return this._reserved;
    }

    public Short getTables() {
        return this._tables;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<GetFeaturesOutput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public GetFeaturesOutputBuilder setActionsV10(ActionTypeV10 value) {
        this._actionsV10 = value;
        return this;
    }

    public GetFeaturesOutputBuilder setAuxiliaryId(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._auxiliaryId = value;
        return this;
    }

    public GetFeaturesOutputBuilder setBuffers(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._buffers = value;
        return this;
    }

    public GetFeaturesOutputBuilder setCapabilities(Capabilities value) {
        this._capabilities = value;
        return this;
    }

    public GetFeaturesOutputBuilder setCapabilitiesV10(CapabilitiesV10 value) {
        this._capabilitiesV10 = value;
        return this;
    }

    public GetFeaturesOutputBuilder setDatapathId(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._datapathId = value;
        return this;
    }

    public GetFeaturesOutputBuilder setPhyPort(List<PhyPort> value) {
        this._phyPort = value;
        return this;
    }

    public GetFeaturesOutputBuilder setReserved(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._reserved = value;
        return this;
    }

    public GetFeaturesOutputBuilder setTables(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._tables = value;
        return this;
    }

    public GetFeaturesOutputBuilder setVersion(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._version = value;
        return this;
    }

    public GetFeaturesOutputBuilder setXid(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._xid = value;
        return this;
    }

    public GetFeaturesOutputBuilder addAugmentation(Class<? extends Augmentation<GetFeaturesOutput>> augmentationType, Augmentation<GetFeaturesOutput> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public GetFeaturesOutput build() {
        return new GetFeaturesOutputImpl(this);
    }

    private static final class GetFeaturesOutputImpl
    implements GetFeaturesOutput {
        private final ActionTypeV10 _actionsV10;
        private final Short _auxiliaryId;
        private final Long _buffers;
        private final Capabilities _capabilities;
        private final CapabilitiesV10 _capabilitiesV10;
        private final BigInteger _datapathId;
        private final List<PhyPort> _phyPort;
        private final Long _reserved;
        private final Short _tables;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<GetFeaturesOutput>>, Augmentation<GetFeaturesOutput>> augmentation = new HashMap<Class<? extends Augmentation<GetFeaturesOutput>>, Augmentation<GetFeaturesOutput>>();

        public Class<GetFeaturesOutput> getImplementedInterface() {
            return GetFeaturesOutput.class;
        }

        private GetFeaturesOutputImpl(GetFeaturesOutputBuilder builder) {
            this._actionsV10 = builder.getActionsV10();
            this._auxiliaryId = builder.getAuxiliaryId();
            this._buffers = builder.getBuffers();
            this._capabilities = builder.getCapabilities();
            this._capabilitiesV10 = builder.getCapabilitiesV10();
            this._datapathId = builder.getDatapathId();
            this._phyPort = builder.getPhyPort();
            this._reserved = builder.getReserved();
            this._tables = builder.getTables();
            this._version = builder.getVersion();
            this._xid = builder.getXid();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public ActionTypeV10 getActionsV10() {
            return this._actionsV10;
        }

        @Override
        public Short getAuxiliaryId() {
            return this._auxiliaryId;
        }

        @Override
        public Long getBuffers() {
            return this._buffers;
        }

        @Override
        public Capabilities getCapabilities() {
            return this._capabilities;
        }

        @Override
        public CapabilitiesV10 getCapabilitiesV10() {
            return this._capabilitiesV10;
        }

        @Override
        public BigInteger getDatapathId() {
            return this._datapathId;
        }

        @Override
        public List<PhyPort> getPhyPort() {
            return this._phyPort;
        }

        @Override
        public Long getReserved() {
            return this._reserved;
        }

        @Override
        public Short getTables() {
            return this._tables;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<GetFeaturesOutput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._actionsV10 == null ? 0 : this._actionsV10.hashCode());
            result = 31 * result + (this._auxiliaryId == null ? 0 : this._auxiliaryId.hashCode());
            result = 31 * result + (this._buffers == null ? 0 : this._buffers.hashCode());
            result = 31 * result + (this._capabilities == null ? 0 : this._capabilities.hashCode());
            result = 31 * result + (this._capabilitiesV10 == null ? 0 : this._capabilitiesV10.hashCode());
            result = 31 * result + (this._datapathId == null ? 0 : this._datapathId.hashCode());
            result = 31 * result + (this._phyPort == null ? 0 : this._phyPort.hashCode());
            result = 31 * result + (this._reserved == null ? 0 : this._reserved.hashCode());
            result = 31 * result + (this._tables == null ? 0 : this._tables.hashCode());
            result = 31 * result + (this._version == null ? 0 : this._version.hashCode());
            result = 31 * result + (this._xid == null ? 0 : this._xid.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GetFeaturesOutputImpl other = (GetFeaturesOutputImpl)obj;
            if (this._actionsV10 == null ? other._actionsV10 != null : !this._actionsV10.equals(other._actionsV10)) {
                return false;
            }
            if (this._auxiliaryId == null ? other._auxiliaryId != null : !this._auxiliaryId.equals(other._auxiliaryId)) {
                return false;
            }
            if (this._buffers == null ? other._buffers != null : !this._buffers.equals(other._buffers)) {
                return false;
            }
            if (this._capabilities == null ? other._capabilities != null : !this._capabilities.equals(other._capabilities)) {
                return false;
            }
            if (this._capabilitiesV10 == null ? other._capabilitiesV10 != null : !this._capabilitiesV10.equals(other._capabilitiesV10)) {
                return false;
            }
            if (this._datapathId == null ? other._datapathId != null : !this._datapathId.equals(other._datapathId)) {
                return false;
            }
            if (this._phyPort == null ? other._phyPort != null : !this._phyPort.equals(other._phyPort)) {
                return false;
            }
            if (this._reserved == null ? other._reserved != null : !this._reserved.equals(other._reserved)) {
                return false;
            }
            if (this._tables == null ? other._tables != null : !this._tables.equals(other._tables)) {
                return false;
            }
            if (this._version == null ? other._version != null : !this._version.equals(other._version)) {
                return false;
            }
            if (this._xid == null ? other._xid != null : !this._xid.equals(other._xid)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("GetFeaturesOutput [_actionsV10=");
            builder.append(this._actionsV10);
            builder.append(", _auxiliaryId=");
            builder.append(this._auxiliaryId);
            builder.append(", _buffers=");
            builder.append(this._buffers);
            builder.append(", _capabilities=");
            builder.append(this._capabilities);
            builder.append(", _capabilitiesV10=");
            builder.append(this._capabilitiesV10);
            builder.append(", _datapathId=");
            builder.append(this._datapathId);
            builder.append(", _phyPort=");
            builder.append(this._phyPort);
            builder.append(", _reserved=");
            builder.append(this._reserved);
            builder.append(", _tables=");
            builder.append(this._tables);
            builder.append(", _version=");
            builder.append(this._version);
            builder.append(", _xid=");
            builder.append(this._xid);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

