/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.SwitchConfigFlag;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetConfigOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetConfigReply;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GetConfigOutputBuilder {
    private SwitchConfigFlag _flags;
    private Integer _missSendLen;
    private Short _version;
    private Long _xid;
    private Map<Class<? extends Augmentation<GetConfigOutput>>, Augmentation<GetConfigOutput>> augmentation = new HashMap<Class<? extends Augmentation<GetConfigOutput>>, Augmentation<GetConfigOutput>>();

    public GetConfigOutputBuilder() {
    }

    public GetConfigOutputBuilder(GetConfigReply arg) {
        this._flags = arg.getFlags();
        this._missSendLen = arg.getMissSendLen();
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public GetConfigOutputBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof GetConfigReply) {
            this._flags = ((GetConfigReply)arg).getFlags();
            this._missSendLen = ((GetConfigReply)arg).getMissSendLen();
            isValidArg = true;
        }
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetConfigReply, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader] \nbut was: " + arg);
        }
    }

    public SwitchConfigFlag getFlags() {
        return this._flags;
    }

    public Integer getMissSendLen() {
        return this._missSendLen;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<GetConfigOutput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public GetConfigOutputBuilder setFlags(SwitchConfigFlag value) {
        this._flags = value;
        return this;
    }

    public GetConfigOutputBuilder setMissSendLen(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._missSendLen = value;
        return this;
    }

    public GetConfigOutputBuilder setVersion(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._version = value;
        return this;
    }

    public GetConfigOutputBuilder setXid(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._xid = value;
        return this;
    }

    public GetConfigOutputBuilder addAugmentation(Class<? extends Augmentation<GetConfigOutput>> augmentationType, Augmentation<GetConfigOutput> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public GetConfigOutput build() {
        return new GetConfigOutputImpl(this);
    }

    private static final class GetConfigOutputImpl
    implements GetConfigOutput {
        private final SwitchConfigFlag _flags;
        private final Integer _missSendLen;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<GetConfigOutput>>, Augmentation<GetConfigOutput>> augmentation = new HashMap<Class<? extends Augmentation<GetConfigOutput>>, Augmentation<GetConfigOutput>>();

        public Class<GetConfigOutput> getImplementedInterface() {
            return GetConfigOutput.class;
        }

        private GetConfigOutputImpl(GetConfigOutputBuilder builder) {
            this._flags = builder.getFlags();
            this._missSendLen = builder.getMissSendLen();
            this._version = builder.getVersion();
            this._xid = builder.getXid();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public SwitchConfigFlag getFlags() {
            return this._flags;
        }

        @Override
        public Integer getMissSendLen() {
            return this._missSendLen;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<GetConfigOutput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._flags == null ? 0 : this._flags.hashCode());
            result = 31 * result + (this._missSendLen == null ? 0 : this._missSendLen.hashCode());
            result = 31 * result + (this._version == null ? 0 : this._version.hashCode());
            result = 31 * result + (this._xid == null ? 0 : this._xid.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GetConfigOutputImpl other = (GetConfigOutputImpl)obj;
            if (this._flags == null ? other._flags != null : !this._flags.equals((Object)other._flags)) {
                return false;
            }
            if (this._missSendLen == null ? other._missSendLen != null : !this._missSendLen.equals(other._missSendLen)) {
                return false;
            }
            if (this._version == null ? other._version != null : !this._version.equals(other._version)) {
                return false;
            }
            if (this._xid == null ? other._xid != null : !this._xid.equals(other._xid)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("GetConfigOutput [_flags=");
            builder.append((Object)this._flags);
            builder.append(", _missSendLen=");
            builder.append(this._missSendLen);
            builder.append(", _version=");
            builder.append(this._version);
            builder.append(", _xid=");
            builder.append(this._xid);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

