/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowRemovedReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.MatchV10Grouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.match.v10.grouping.MatchV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowRemoved;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowRemovedMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MatchGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.match.grouping.Match;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class FlowRemovedMessageBuilder {
    private BigInteger _byteCount;
    private BigInteger _cookie;
    private Long _durationNsec;
    private Long _durationSec;
    private Integer _hardTimeout;
    private Integer _idleTimeout;
    private BigInteger _packetCount;
    private Integer _priority;
    private FlowRemovedReason _reason;
    private TableId _tableId;
    private MatchV10 _matchV10;
    private Match _match;
    private Short _version;
    private Long _xid;
    private Map<Class<? extends Augmentation<FlowRemovedMessage>>, Augmentation<FlowRemovedMessage>> augmentation = new HashMap<Class<? extends Augmentation<FlowRemovedMessage>>, Augmentation<FlowRemovedMessage>>();

    public FlowRemovedMessageBuilder() {
    }

    public FlowRemovedMessageBuilder(FlowRemoved arg) {
        this._byteCount = arg.getByteCount();
        this._cookie = arg.getCookie();
        this._durationNsec = arg.getDurationNsec();
        this._durationSec = arg.getDurationSec();
        this._hardTimeout = arg.getHardTimeout();
        this._idleTimeout = arg.getIdleTimeout();
        this._packetCount = arg.getPacketCount();
        this._priority = arg.getPriority();
        this._reason = arg.getReason();
        this._tableId = arg.getTableId();
        this._matchV10 = arg.getMatchV10();
        this._match = arg.getMatch();
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public FlowRemovedMessageBuilder(MatchV10Grouping arg) {
        this._matchV10 = arg.getMatchV10();
    }

    public FlowRemovedMessageBuilder(MatchGrouping arg) {
        this._match = arg.getMatch();
    }

    public FlowRemovedMessageBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (arg instanceof FlowRemoved) {
            this._byteCount = ((FlowRemoved)arg).getByteCount();
            this._cookie = ((FlowRemoved)arg).getCookie();
            this._durationNsec = ((FlowRemoved)arg).getDurationNsec();
            this._durationSec = ((FlowRemoved)arg).getDurationSec();
            this._hardTimeout = ((FlowRemoved)arg).getHardTimeout();
            this._idleTimeout = ((FlowRemoved)arg).getIdleTimeout();
            this._packetCount = ((FlowRemoved)arg).getPacketCount();
            this._priority = ((FlowRemoved)arg).getPriority();
            this._reason = ((FlowRemoved)arg).getReason();
            this._tableId = ((FlowRemoved)arg).getTableId();
            isValidArg = true;
        }
        if (arg instanceof MatchV10Grouping) {
            this._matchV10 = ((MatchV10Grouping)arg).getMatchV10();
            isValidArg = true;
        }
        if (arg instanceof MatchGrouping) {
            this._match = ((MatchGrouping)arg).getMatch();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowRemoved, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.MatchV10Grouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MatchGrouping] \nbut was: " + arg);
        }
    }

    public BigInteger getByteCount() {
        return this._byteCount;
    }

    public BigInteger getCookie() {
        return this._cookie;
    }

    public Long getDurationNsec() {
        return this._durationNsec;
    }

    public Long getDurationSec() {
        return this._durationSec;
    }

    public Integer getHardTimeout() {
        return this._hardTimeout;
    }

    public Integer getIdleTimeout() {
        return this._idleTimeout;
    }

    public BigInteger getPacketCount() {
        return this._packetCount;
    }

    public Integer getPriority() {
        return this._priority;
    }

    public FlowRemovedReason getReason() {
        return this._reason;
    }

    public TableId getTableId() {
        return this._tableId;
    }

    public MatchV10 getMatchV10() {
        return this._matchV10;
    }

    public Match getMatch() {
        return this._match;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<FlowRemovedMessage>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public FlowRemovedMessageBuilder setByteCount(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._byteCount = value;
        return this;
    }

    public FlowRemovedMessageBuilder setCookie(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._cookie = value;
        return this;
    }

    public FlowRemovedMessageBuilder setDurationNsec(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._durationNsec = value;
        return this;
    }

    public FlowRemovedMessageBuilder setDurationSec(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._durationSec = value;
        return this;
    }

    public FlowRemovedMessageBuilder setHardTimeout(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._hardTimeout = value;
        return this;
    }

    public FlowRemovedMessageBuilder setIdleTimeout(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._idleTimeout = value;
        return this;
    }

    public FlowRemovedMessageBuilder setPacketCount(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._packetCount = value;
        return this;
    }

    public FlowRemovedMessageBuilder setPriority(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._priority = value;
        return this;
    }

    public FlowRemovedMessageBuilder setReason(FlowRemovedReason value) {
        this._reason = value;
        return this;
    }

    public FlowRemovedMessageBuilder setTableId(TableId value) {
        this._tableId = value;
        return this;
    }

    public FlowRemovedMessageBuilder setMatchV10(MatchV10 value) {
        this._matchV10 = value;
        return this;
    }

    public FlowRemovedMessageBuilder setMatch(Match value) {
        this._match = value;
        return this;
    }

    public FlowRemovedMessageBuilder setVersion(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._version = value;
        return this;
    }

    public FlowRemovedMessageBuilder setXid(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._xid = value;
        return this;
    }

    public FlowRemovedMessageBuilder addAugmentation(Class<? extends Augmentation<FlowRemovedMessage>> augmentationType, Augmentation<FlowRemovedMessage> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public FlowRemovedMessage build() {
        return new FlowRemovedMessageImpl(this);
    }

    private static final class FlowRemovedMessageImpl
    implements FlowRemovedMessage {
        private final BigInteger _byteCount;
        private final BigInteger _cookie;
        private final Long _durationNsec;
        private final Long _durationSec;
        private final Integer _hardTimeout;
        private final Integer _idleTimeout;
        private final BigInteger _packetCount;
        private final Integer _priority;
        private final FlowRemovedReason _reason;
        private final TableId _tableId;
        private final MatchV10 _matchV10;
        private final Match _match;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<FlowRemovedMessage>>, Augmentation<FlowRemovedMessage>> augmentation = new HashMap<Class<? extends Augmentation<FlowRemovedMessage>>, Augmentation<FlowRemovedMessage>>();

        public Class<FlowRemovedMessage> getImplementedInterface() {
            return FlowRemovedMessage.class;
        }

        private FlowRemovedMessageImpl(FlowRemovedMessageBuilder builder) {
            this._byteCount = builder.getByteCount();
            this._cookie = builder.getCookie();
            this._durationNsec = builder.getDurationNsec();
            this._durationSec = builder.getDurationSec();
            this._hardTimeout = builder.getHardTimeout();
            this._idleTimeout = builder.getIdleTimeout();
            this._packetCount = builder.getPacketCount();
            this._priority = builder.getPriority();
            this._reason = builder.getReason();
            this._tableId = builder.getTableId();
            this._matchV10 = builder.getMatchV10();
            this._match = builder.getMatch();
            this._version = builder.getVersion();
            this._xid = builder.getXid();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public BigInteger getByteCount() {
            return this._byteCount;
        }

        @Override
        public BigInteger getCookie() {
            return this._cookie;
        }

        @Override
        public Long getDurationNsec() {
            return this._durationNsec;
        }

        @Override
        public Long getDurationSec() {
            return this._durationSec;
        }

        @Override
        public Integer getHardTimeout() {
            return this._hardTimeout;
        }

        @Override
        public Integer getIdleTimeout() {
            return this._idleTimeout;
        }

        @Override
        public BigInteger getPacketCount() {
            return this._packetCount;
        }

        @Override
        public Integer getPriority() {
            return this._priority;
        }

        @Override
        public FlowRemovedReason getReason() {
            return this._reason;
        }

        @Override
        public TableId getTableId() {
            return this._tableId;
        }

        @Override
        public MatchV10 getMatchV10() {
            return this._matchV10;
        }

        @Override
        public Match getMatch() {
            return this._match;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<FlowRemovedMessage>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._byteCount == null ? 0 : this._byteCount.hashCode());
            result = 31 * result + (this._cookie == null ? 0 : this._cookie.hashCode());
            result = 31 * result + (this._durationNsec == null ? 0 : this._durationNsec.hashCode());
            result = 31 * result + (this._durationSec == null ? 0 : this._durationSec.hashCode());
            result = 31 * result + (this._hardTimeout == null ? 0 : this._hardTimeout.hashCode());
            result = 31 * result + (this._idleTimeout == null ? 0 : this._idleTimeout.hashCode());
            result = 31 * result + (this._packetCount == null ? 0 : this._packetCount.hashCode());
            result = 31 * result + (this._priority == null ? 0 : this._priority.hashCode());
            result = 31 * result + (this._reason == null ? 0 : this._reason.hashCode());
            result = 31 * result + (this._tableId == null ? 0 : this._tableId.hashCode());
            result = 31 * result + (this._matchV10 == null ? 0 : this._matchV10.hashCode());
            result = 31 * result + (this._match == null ? 0 : this._match.hashCode());
            result = 31 * result + (this._version == null ? 0 : this._version.hashCode());
            result = 31 * result + (this._xid == null ? 0 : this._xid.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FlowRemovedMessageImpl other = (FlowRemovedMessageImpl)obj;
            if (this._byteCount == null ? other._byteCount != null : !this._byteCount.equals(other._byteCount)) {
                return false;
            }
            if (this._cookie == null ? other._cookie != null : !this._cookie.equals(other._cookie)) {
                return false;
            }
            if (this._durationNsec == null ? other._durationNsec != null : !this._durationNsec.equals(other._durationNsec)) {
                return false;
            }
            if (this._durationSec == null ? other._durationSec != null : !this._durationSec.equals(other._durationSec)) {
                return false;
            }
            if (this._hardTimeout == null ? other._hardTimeout != null : !this._hardTimeout.equals(other._hardTimeout)) {
                return false;
            }
            if (this._idleTimeout == null ? other._idleTimeout != null : !this._idleTimeout.equals(other._idleTimeout)) {
                return false;
            }
            if (this._packetCount == null ? other._packetCount != null : !this._packetCount.equals(other._packetCount)) {
                return false;
            }
            if (this._priority == null ? other._priority != null : !this._priority.equals(other._priority)) {
                return false;
            }
            if (this._reason == null ? other._reason != null : !this._reason.equals((Object)other._reason)) {
                return false;
            }
            if (this._tableId == null ? other._tableId != null : !this._tableId.equals(other._tableId)) {
                return false;
            }
            if (this._matchV10 == null ? other._matchV10 != null : !this._matchV10.equals(other._matchV10)) {
                return false;
            }
            if (this._match == null ? other._match != null : !this._match.equals(other._match)) {
                return false;
            }
            if (this._version == null ? other._version != null : !this._version.equals(other._version)) {
                return false;
            }
            if (this._xid == null ? other._xid != null : !this._xid.equals(other._xid)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("FlowRemovedMessage [_byteCount=");
            builder.append(this._byteCount);
            builder.append(", _cookie=");
            builder.append(this._cookie);
            builder.append(", _durationNsec=");
            builder.append(this._durationNsec);
            builder.append(", _durationSec=");
            builder.append(this._durationSec);
            builder.append(", _hardTimeout=");
            builder.append(this._hardTimeout);
            builder.append(", _idleTimeout=");
            builder.append(this._idleTimeout);
            builder.append(", _packetCount=");
            builder.append(this._packetCount);
            builder.append(", _priority=");
            builder.append(this._priority);
            builder.append(", _reason=");
            builder.append((Object)this._reason);
            builder.append(", _tableId=");
            builder.append(this._tableId);
            builder.append(", _matchV10=");
            builder.append(this._matchV10);
            builder.append(", _match=");
            builder.append(this._match);
            builder.append(", _version=");
            builder.append(this._version);
            builder.append(", _xid=");
            builder.append(this._xid);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

