/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.Actions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions.ActionsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.Instructions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowModCommand;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowModFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowModFlagsV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.MatchV10Grouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.match.v10.grouping.MatchV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowMod;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MatchGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.match.grouping.Match;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class FlowModInputBuilder {
    private Long _bufferId;
    private FlowModCommand _command;
    private BigInteger _cookie;
    private BigInteger _cookieMask;
    private FlowModFlags _flags;
    private FlowModFlagsV10 _flagsV10;
    private Integer _hardTimeout;
    private Integer _idleTimeout;
    private Long _outGroup;
    private PortNumber _outPort;
    private Integer _priority;
    private TableId _tableId;
    private List<org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.Instructions> _instructions;
    private List<ActionsList> _actionsList;
    private MatchV10 _matchV10;
    private Match _match;
    private Short _version;
    private Long _xid;
    private Map<Class<? extends Augmentation<FlowModInput>>, Augmentation<FlowModInput>> augmentation = new HashMap<Class<? extends Augmentation<FlowModInput>>, Augmentation<FlowModInput>>();

    public FlowModInputBuilder() {
    }

    public FlowModInputBuilder(FlowMod arg) {
        this._bufferId = arg.getBufferId();
        this._command = arg.getCommand();
        this._cookie = arg.getCookie();
        this._cookieMask = arg.getCookieMask();
        this._flags = arg.getFlags();
        this._flagsV10 = arg.getFlagsV10();
        this._hardTimeout = arg.getHardTimeout();
        this._idleTimeout = arg.getIdleTimeout();
        this._outGroup = arg.getOutGroup();
        this._outPort = arg.getOutPort();
        this._priority = arg.getPriority();
        this._tableId = arg.getTableId();
        this._instructions = arg.getInstructions();
        this._actionsList = arg.getActionsList();
        this._matchV10 = arg.getMatchV10();
        this._match = arg.getMatch();
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public FlowModInputBuilder(Instructions arg) {
        this._instructions = arg.getInstructions();
    }

    public FlowModInputBuilder(Actions arg) {
        this._actionsList = arg.getActionsList();
    }

    public FlowModInputBuilder(MatchV10Grouping arg) {
        this._matchV10 = arg.getMatchV10();
    }

    public FlowModInputBuilder(MatchGrouping arg) {
        this._match = arg.getMatch();
    }

    public FlowModInputBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof FlowMod) {
            this._bufferId = ((FlowMod)arg).getBufferId();
            this._command = ((FlowMod)arg).getCommand();
            this._cookie = ((FlowMod)arg).getCookie();
            this._cookieMask = ((FlowMod)arg).getCookieMask();
            this._flags = ((FlowMod)arg).getFlags();
            this._flagsV10 = ((FlowMod)arg).getFlagsV10();
            this._hardTimeout = ((FlowMod)arg).getHardTimeout();
            this._idleTimeout = ((FlowMod)arg).getIdleTimeout();
            this._outGroup = ((FlowMod)arg).getOutGroup();
            this._outPort = ((FlowMod)arg).getOutPort();
            this._priority = ((FlowMod)arg).getPriority();
            this._tableId = ((FlowMod)arg).getTableId();
            isValidArg = true;
        }
        if (arg instanceof Actions) {
            this._actionsList = ((Actions)arg).getActionsList();
            isValidArg = true;
        }
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (arg instanceof Instructions) {
            this._instructions = ((Instructions)arg).getInstructions();
            isValidArg = true;
        }
        if (arg instanceof MatchV10Grouping) {
            this._matchV10 = ((MatchV10Grouping)arg).getMatchV10();
            isValidArg = true;
        }
        if (arg instanceof MatchGrouping) {
            this._match = ((MatchGrouping)arg).getMatch();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowMod, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.Actions, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.Instructions, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.MatchV10Grouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MatchGrouping] \nbut was: " + arg);
        }
    }

    public Long getBufferId() {
        return this._bufferId;
    }

    public FlowModCommand getCommand() {
        return this._command;
    }

    public BigInteger getCookie() {
        return this._cookie;
    }

    public BigInteger getCookieMask() {
        return this._cookieMask;
    }

    public FlowModFlags getFlags() {
        return this._flags;
    }

    public FlowModFlagsV10 getFlagsV10() {
        return this._flagsV10;
    }

    public Integer getHardTimeout() {
        return this._hardTimeout;
    }

    public Integer getIdleTimeout() {
        return this._idleTimeout;
    }

    public Long getOutGroup() {
        return this._outGroup;
    }

    public PortNumber getOutPort() {
        return this._outPort;
    }

    public Integer getPriority() {
        return this._priority;
    }

    public TableId getTableId() {
        return this._tableId;
    }

    public List<org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.Instructions> getInstructions() {
        return this._instructions;
    }

    public List<ActionsList> getActionsList() {
        return this._actionsList;
    }

    public MatchV10 getMatchV10() {
        return this._matchV10;
    }

    public Match getMatch() {
        return this._match;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<FlowModInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public FlowModInputBuilder setBufferId(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._bufferId = value;
        return this;
    }

    public FlowModInputBuilder setCommand(FlowModCommand value) {
        this._command = value;
        return this;
    }

    public FlowModInputBuilder setCookie(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._cookie = value;
        return this;
    }

    public FlowModInputBuilder setCookieMask(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._cookieMask = value;
        return this;
    }

    public FlowModInputBuilder setFlags(FlowModFlags value) {
        this._flags = value;
        return this;
    }

    public FlowModInputBuilder setFlagsV10(FlowModFlagsV10 value) {
        this._flagsV10 = value;
        return this;
    }

    public FlowModInputBuilder setHardTimeout(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._hardTimeout = value;
        return this;
    }

    public FlowModInputBuilder setIdleTimeout(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._idleTimeout = value;
        return this;
    }

    public FlowModInputBuilder setOutGroup(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._outGroup = value;
        return this;
    }

    public FlowModInputBuilder setOutPort(PortNumber value) {
        this._outPort = value;
        return this;
    }

    public FlowModInputBuilder setPriority(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._priority = value;
        return this;
    }

    public FlowModInputBuilder setTableId(TableId value) {
        this._tableId = value;
        return this;
    }

    public FlowModInputBuilder setInstructions(List<org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.Instructions> value) {
        this._instructions = value;
        return this;
    }

    public FlowModInputBuilder setActionsList(List<ActionsList> value) {
        this._actionsList = value;
        return this;
    }

    public FlowModInputBuilder setMatchV10(MatchV10 value) {
        this._matchV10 = value;
        return this;
    }

    public FlowModInputBuilder setMatch(Match value) {
        this._match = value;
        return this;
    }

    public FlowModInputBuilder setVersion(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._version = value;
        return this;
    }

    public FlowModInputBuilder setXid(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._xid = value;
        return this;
    }

    public FlowModInputBuilder addAugmentation(Class<? extends Augmentation<FlowModInput>> augmentationType, Augmentation<FlowModInput> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public FlowModInput build() {
        return new FlowModInputImpl(this);
    }

    private static final class FlowModInputImpl
    implements FlowModInput {
        private final Long _bufferId;
        private final FlowModCommand _command;
        private final BigInteger _cookie;
        private final BigInteger _cookieMask;
        private final FlowModFlags _flags;
        private final FlowModFlagsV10 _flagsV10;
        private final Integer _hardTimeout;
        private final Integer _idleTimeout;
        private final Long _outGroup;
        private final PortNumber _outPort;
        private final Integer _priority;
        private final TableId _tableId;
        private final List<org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.Instructions> _instructions;
        private final List<ActionsList> _actionsList;
        private final MatchV10 _matchV10;
        private final Match _match;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<FlowModInput>>, Augmentation<FlowModInput>> augmentation = new HashMap<Class<? extends Augmentation<FlowModInput>>, Augmentation<FlowModInput>>();

        public Class<FlowModInput> getImplementedInterface() {
            return FlowModInput.class;
        }

        private FlowModInputImpl(FlowModInputBuilder builder) {
            this._bufferId = builder.getBufferId();
            this._command = builder.getCommand();
            this._cookie = builder.getCookie();
            this._cookieMask = builder.getCookieMask();
            this._flags = builder.getFlags();
            this._flagsV10 = builder.getFlagsV10();
            this._hardTimeout = builder.getHardTimeout();
            this._idleTimeout = builder.getIdleTimeout();
            this._outGroup = builder.getOutGroup();
            this._outPort = builder.getOutPort();
            this._priority = builder.getPriority();
            this._tableId = builder.getTableId();
            this._instructions = builder.getInstructions();
            this._actionsList = builder.getActionsList();
            this._matchV10 = builder.getMatchV10();
            this._match = builder.getMatch();
            this._version = builder.getVersion();
            this._xid = builder.getXid();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Long getBufferId() {
            return this._bufferId;
        }

        @Override
        public FlowModCommand getCommand() {
            return this._command;
        }

        @Override
        public BigInteger getCookie() {
            return this._cookie;
        }

        @Override
        public BigInteger getCookieMask() {
            return this._cookieMask;
        }

        @Override
        public FlowModFlags getFlags() {
            return this._flags;
        }

        @Override
        public FlowModFlagsV10 getFlagsV10() {
            return this._flagsV10;
        }

        @Override
        public Integer getHardTimeout() {
            return this._hardTimeout;
        }

        @Override
        public Integer getIdleTimeout() {
            return this._idleTimeout;
        }

        @Override
        public Long getOutGroup() {
            return this._outGroup;
        }

        @Override
        public PortNumber getOutPort() {
            return this._outPort;
        }

        @Override
        public Integer getPriority() {
            return this._priority;
        }

        @Override
        public TableId getTableId() {
            return this._tableId;
        }

        @Override
        public List<org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.Instructions> getInstructions() {
            return this._instructions;
        }

        @Override
        public List<ActionsList> getActionsList() {
            return this._actionsList;
        }

        @Override
        public MatchV10 getMatchV10() {
            return this._matchV10;
        }

        @Override
        public Match getMatch() {
            return this._match;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<FlowModInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._bufferId == null ? 0 : this._bufferId.hashCode());
            result = 31 * result + (this._command == null ? 0 : this._command.hashCode());
            result = 31 * result + (this._cookie == null ? 0 : this._cookie.hashCode());
            result = 31 * result + (this._cookieMask == null ? 0 : this._cookieMask.hashCode());
            result = 31 * result + (this._flags == null ? 0 : this._flags.hashCode());
            result = 31 * result + (this._flagsV10 == null ? 0 : this._flagsV10.hashCode());
            result = 31 * result + (this._hardTimeout == null ? 0 : this._hardTimeout.hashCode());
            result = 31 * result + (this._idleTimeout == null ? 0 : this._idleTimeout.hashCode());
            result = 31 * result + (this._outGroup == null ? 0 : this._outGroup.hashCode());
            result = 31 * result + (this._outPort == null ? 0 : this._outPort.hashCode());
            result = 31 * result + (this._priority == null ? 0 : this._priority.hashCode());
            result = 31 * result + (this._tableId == null ? 0 : this._tableId.hashCode());
            result = 31 * result + (this._instructions == null ? 0 : this._instructions.hashCode());
            result = 31 * result + (this._actionsList == null ? 0 : this._actionsList.hashCode());
            result = 31 * result + (this._matchV10 == null ? 0 : this._matchV10.hashCode());
            result = 31 * result + (this._match == null ? 0 : this._match.hashCode());
            result = 31 * result + (this._version == null ? 0 : this._version.hashCode());
            result = 31 * result + (this._xid == null ? 0 : this._xid.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FlowModInputImpl other = (FlowModInputImpl)obj;
            if (this._bufferId == null ? other._bufferId != null : !this._bufferId.equals(other._bufferId)) {
                return false;
            }
            if (this._command == null ? other._command != null : !this._command.equals((Object)other._command)) {
                return false;
            }
            if (this._cookie == null ? other._cookie != null : !this._cookie.equals(other._cookie)) {
                return false;
            }
            if (this._cookieMask == null ? other._cookieMask != null : !this._cookieMask.equals(other._cookieMask)) {
                return false;
            }
            if (this._flags == null ? other._flags != null : !this._flags.equals(other._flags)) {
                return false;
            }
            if (this._flagsV10 == null ? other._flagsV10 != null : !this._flagsV10.equals(other._flagsV10)) {
                return false;
            }
            if (this._hardTimeout == null ? other._hardTimeout != null : !this._hardTimeout.equals(other._hardTimeout)) {
                return false;
            }
            if (this._idleTimeout == null ? other._idleTimeout != null : !this._idleTimeout.equals(other._idleTimeout)) {
                return false;
            }
            if (this._outGroup == null ? other._outGroup != null : !this._outGroup.equals(other._outGroup)) {
                return false;
            }
            if (this._outPort == null ? other._outPort != null : !this._outPort.equals(other._outPort)) {
                return false;
            }
            if (this._priority == null ? other._priority != null : !this._priority.equals(other._priority)) {
                return false;
            }
            if (this._tableId == null ? other._tableId != null : !this._tableId.equals(other._tableId)) {
                return false;
            }
            if (this._instructions == null ? other._instructions != null : !this._instructions.equals(other._instructions)) {
                return false;
            }
            if (this._actionsList == null ? other._actionsList != null : !this._actionsList.equals(other._actionsList)) {
                return false;
            }
            if (this._matchV10 == null ? other._matchV10 != null : !this._matchV10.equals(other._matchV10)) {
                return false;
            }
            if (this._match == null ? other._match != null : !this._match.equals(other._match)) {
                return false;
            }
            if (this._version == null ? other._version != null : !this._version.equals(other._version)) {
                return false;
            }
            if (this._xid == null ? other._xid != null : !this._xid.equals(other._xid)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("FlowModInput [_bufferId=");
            builder.append(this._bufferId);
            builder.append(", _command=");
            builder.append((Object)this._command);
            builder.append(", _cookie=");
            builder.append(this._cookie);
            builder.append(", _cookieMask=");
            builder.append(this._cookieMask);
            builder.append(", _flags=");
            builder.append(this._flags);
            builder.append(", _flagsV10=");
            builder.append(this._flagsV10);
            builder.append(", _hardTimeout=");
            builder.append(this._hardTimeout);
            builder.append(", _idleTimeout=");
            builder.append(this._idleTimeout);
            builder.append(", _outGroup=");
            builder.append(this._outGroup);
            builder.append(", _outPort=");
            builder.append(this._outPort);
            builder.append(", _priority=");
            builder.append(this._priority);
            builder.append(", _tableId=");
            builder.append(this._tableId);
            builder.append(", _instructions=");
            builder.append(this._instructions);
            builder.append(", _actionsList=");
            builder.append(this._actionsList);
            builder.append(", _matchV10=");
            builder.append(this._matchV10);
            builder.append(", _match=");
            builder.append(this._match);
            builder.append(", _version=");
            builder.append(this._version);
            builder.append(", _xid=");
            builder.append(this._xid);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

