/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.Experimenter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ExperimenterMessageBuilder {
    private byte[] _data;
    private Long _expType;
    private Long _experimenter;
    private Short _version;
    private Long _xid;
    private Map<Class<? extends Augmentation<ExperimenterMessage>>, Augmentation<ExperimenterMessage>> augmentation = new HashMap<Class<? extends Augmentation<ExperimenterMessage>>, Augmentation<ExperimenterMessage>>();

    public ExperimenterMessageBuilder() {
    }

    public ExperimenterMessageBuilder(Experimenter arg) {
        this._data = arg.getData();
        this._expType = arg.getExpType();
        this._experimenter = arg.getExperimenter();
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public ExperimenterMessageBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Experimenter) {
            this._data = ((Experimenter)arg).getData();
            this._expType = ((Experimenter)arg).getExpType();
            this._experimenter = ((Experimenter)arg).getExperimenter();
            isValidArg = true;
        }
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.Experimenter, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader] \nbut was: " + arg);
        }
    }

    public byte[] getData() {
        return this._data;
    }

    public Long getExpType() {
        return this._expType;
    }

    public Long getExperimenter() {
        return this._experimenter;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<ExperimenterMessage>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ExperimenterMessageBuilder setData(byte[] value) {
        this._data = value;
        return this;
    }

    public ExperimenterMessageBuilder setExpType(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._expType = value;
        return this;
    }

    public ExperimenterMessageBuilder setExperimenter(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._experimenter = value;
        return this;
    }

    public ExperimenterMessageBuilder setVersion(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._version = value;
        return this;
    }

    public ExperimenterMessageBuilder setXid(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._xid = value;
        return this;
    }

    public ExperimenterMessageBuilder addAugmentation(Class<? extends Augmentation<ExperimenterMessage>> augmentationType, Augmentation<ExperimenterMessage> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ExperimenterMessage build() {
        return new ExperimenterMessageImpl(this);
    }

    private static final class ExperimenterMessageImpl
    implements ExperimenterMessage {
        private final byte[] _data;
        private final Long _expType;
        private final Long _experimenter;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<ExperimenterMessage>>, Augmentation<ExperimenterMessage>> augmentation = new HashMap<Class<? extends Augmentation<ExperimenterMessage>>, Augmentation<ExperimenterMessage>>();

        public Class<ExperimenterMessage> getImplementedInterface() {
            return ExperimenterMessage.class;
        }

        private ExperimenterMessageImpl(ExperimenterMessageBuilder builder) {
            this._data = builder.getData();
            this._expType = builder.getExpType();
            this._experimenter = builder.getExperimenter();
            this._version = builder.getVersion();
            this._xid = builder.getXid();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public byte[] getData() {
            return this._data;
        }

        @Override
        public Long getExpType() {
            return this._expType;
        }

        @Override
        public Long getExperimenter() {
            return this._experimenter;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<ExperimenterMessage>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._data == null ? 0 : Arrays.hashCode(this._data));
            result = 31 * result + (this._expType == null ? 0 : this._expType.hashCode());
            result = 31 * result + (this._experimenter == null ? 0 : this._experimenter.hashCode());
            result = 31 * result + (this._version == null ? 0 : this._version.hashCode());
            result = 31 * result + (this._xid == null ? 0 : this._xid.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExperimenterMessageImpl other = (ExperimenterMessageImpl)obj;
            if (this._data == null ? other._data != null : !Arrays.equals(this._data, other._data)) {
                return false;
            }
            if (this._expType == null ? other._expType != null : !this._expType.equals(other._expType)) {
                return false;
            }
            if (this._experimenter == null ? other._experimenter != null : !this._experimenter.equals(other._experimenter)) {
                return false;
            }
            if (this._version == null ? other._version != null : !this._version.equals(other._version)) {
                return false;
            }
            if (this._xid == null ? other._xid != null : !this._xid.equals(other._xid)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ExperimenterMessage [_data=");
            builder.append(Arrays.toString(this._data));
            builder.append(", _expType=");
            builder.append(this._expType);
            builder.append(", _experimenter=");
            builder.append(this._experimenter);
            builder.append(", _version=");
            builder.append(this._version);
            builder.append(", _xid=");
            builder.append(this._xid);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

