/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.Error;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ErrorMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ErrorMessageBuilder {
    private Integer _code;
    private String _codeString;
    private byte[] _data;
    private Integer _type;
    private String _typeString;
    private Short _version;
    private Long _xid;
    private Map<Class<? extends Augmentation<ErrorMessage>>, Augmentation<ErrorMessage>> augmentation = new HashMap<Class<? extends Augmentation<ErrorMessage>>, Augmentation<ErrorMessage>>();

    public ErrorMessageBuilder() {
    }

    public ErrorMessageBuilder(Error arg) {
        this._code = arg.getCode();
        this._codeString = arg.getCodeString();
        this._data = arg.getData();
        this._type = arg.getType();
        this._typeString = arg.getTypeString();
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public ErrorMessageBuilder(OfHeader arg) {
        this._version = arg.getVersion();
        this._xid = arg.getXid();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Error) {
            this._code = ((Error)arg).getCode();
            this._codeString = ((Error)arg).getCodeString();
            this._data = ((Error)arg).getData();
            this._type = ((Error)arg).getType();
            this._typeString = ((Error)arg).getTypeString();
            isValidArg = true;
        }
        if (arg instanceof OfHeader) {
            this._version = ((OfHeader)arg).getVersion();
            this._xid = ((OfHeader)arg).getXid();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.Error, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader] \nbut was: " + arg);
        }
    }

    public Integer getCode() {
        return this._code;
    }

    public String getCodeString() {
        return this._codeString;
    }

    public byte[] getData() {
        return this._data;
    }

    public Integer getType() {
        return this._type;
    }

    public String getTypeString() {
        return this._typeString;
    }

    public Short getVersion() {
        return this._version;
    }

    public Long getXid() {
        return this._xid;
    }

    public <E extends Augmentation<ErrorMessage>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ErrorMessageBuilder setCode(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._code = value;
        return this;
    }

    public ErrorMessageBuilder setCodeString(String value) {
        this._codeString = value;
        return this;
    }

    public ErrorMessageBuilder setData(byte[] value) {
        this._data = value;
        return this;
    }

    public ErrorMessageBuilder setType(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._type = value;
        return this;
    }

    public ErrorMessageBuilder setTypeString(String value) {
        this._typeString = value;
        return this;
    }

    public ErrorMessageBuilder setVersion(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._version = value;
        return this;
    }

    public ErrorMessageBuilder setXid(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._xid = value;
        return this;
    }

    public ErrorMessageBuilder addAugmentation(Class<? extends Augmentation<ErrorMessage>> augmentationType, Augmentation<ErrorMessage> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ErrorMessage build() {
        return new ErrorMessageImpl(this);
    }

    private static final class ErrorMessageImpl
    implements ErrorMessage {
        private final Integer _code;
        private final String _codeString;
        private final byte[] _data;
        private final Integer _type;
        private final String _typeString;
        private final Short _version;
        private final Long _xid;
        private Map<Class<? extends Augmentation<ErrorMessage>>, Augmentation<ErrorMessage>> augmentation = new HashMap<Class<? extends Augmentation<ErrorMessage>>, Augmentation<ErrorMessage>>();

        public Class<ErrorMessage> getImplementedInterface() {
            return ErrorMessage.class;
        }

        private ErrorMessageImpl(ErrorMessageBuilder builder) {
            this._code = builder.getCode();
            this._codeString = builder.getCodeString();
            this._data = builder.getData();
            this._type = builder.getType();
            this._typeString = builder.getTypeString();
            this._version = builder.getVersion();
            this._xid = builder.getXid();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Integer getCode() {
            return this._code;
        }

        @Override
        public String getCodeString() {
            return this._codeString;
        }

        @Override
        public byte[] getData() {
            return this._data;
        }

        @Override
        public Integer getType() {
            return this._type;
        }

        @Override
        public String getTypeString() {
            return this._typeString;
        }

        @Override
        public Short getVersion() {
            return this._version;
        }

        @Override
        public Long getXid() {
            return this._xid;
        }

        public <E extends Augmentation<ErrorMessage>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._code == null ? 0 : this._code.hashCode());
            result = 31 * result + (this._codeString == null ? 0 : this._codeString.hashCode());
            result = 31 * result + (this._data == null ? 0 : Arrays.hashCode(this._data));
            result = 31 * result + (this._type == null ? 0 : this._type.hashCode());
            result = 31 * result + (this._typeString == null ? 0 : this._typeString.hashCode());
            result = 31 * result + (this._version == null ? 0 : this._version.hashCode());
            result = 31 * result + (this._xid == null ? 0 : this._xid.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ErrorMessageImpl other = (ErrorMessageImpl)obj;
            if (this._code == null ? other._code != null : !this._code.equals(other._code)) {
                return false;
            }
            if (this._codeString == null ? other._codeString != null : !this._codeString.equals(other._codeString)) {
                return false;
            }
            if (this._data == null ? other._data != null : !Arrays.equals(this._data, other._data)) {
                return false;
            }
            if (this._type == null ? other._type != null : !this._type.equals(other._type)) {
                return false;
            }
            if (this._typeString == null ? other._typeString != null : !this._typeString.equals(other._typeString)) {
                return false;
            }
            if (this._version == null ? other._version != null : !this._version.equals(other._version)) {
                return false;
            }
            if (this._xid == null ? other._xid != null : !this._xid.equals(other._xid)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ErrorMessage [_code=");
            builder.append(this._code);
            builder.append(", _codeString=");
            builder.append(this._codeString);
            builder.append(", _data=");
            builder.append(Arrays.toString(this._data));
            builder.append(", _type=");
            builder.append(this._type);
            builder.append(", _typeString=");
            builder.append(this._typeString);
            builder.append(", _version=");
            builder.append(this._version);
            builder.append(", _xid=");
            builder.append(this._xid);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

