/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.oxm.fields;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Clazz;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.MatchField;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.oxm.fields.MatchEntries;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.oxm.fields.MatchEntriesKey;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class MatchEntriesBuilder {
    private Boolean _hasMask;
    private Class<? extends Clazz> _oxmClass;
    private Class<? extends MatchField> _oxmMatchField;
    private MatchEntriesKey _key;
    private Map<Class<? extends Augmentation<MatchEntries>>, Augmentation<MatchEntries>> augmentation = new HashMap<Class<? extends Augmentation<MatchEntries>>, Augmentation<MatchEntries>>();

    public Boolean isHasMask() {
        return this._hasMask;
    }

    public Class<? extends Clazz> getOxmClass() {
        return this._oxmClass;
    }

    public Class<? extends MatchField> getOxmMatchField() {
        return this._oxmMatchField;
    }

    public MatchEntriesKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<MatchEntries>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MatchEntriesBuilder setHasMask(Boolean value) {
        this._hasMask = value;
        return this;
    }

    public MatchEntriesBuilder setOxmClass(Class<? extends Clazz> value) {
        this._oxmClass = value;
        return this;
    }

    public MatchEntriesBuilder setOxmMatchField(Class<? extends MatchField> value) {
        this._oxmMatchField = value;
        return this;
    }

    public MatchEntriesBuilder setKey(MatchEntriesKey value) {
        this._key = value;
        return this;
    }

    public MatchEntriesBuilder addAugmentation(Class<? extends Augmentation<MatchEntries>> augmentationType, Augmentation<MatchEntries> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MatchEntries build() {
        return new MatchEntriesImpl(this);
    }

    private static final class MatchEntriesImpl
    implements MatchEntries {
        private final Boolean _hasMask;
        private final Class<? extends Clazz> _oxmClass;
        private final Class<? extends MatchField> _oxmMatchField;
        private final MatchEntriesKey _key;
        private Map<Class<? extends Augmentation<MatchEntries>>, Augmentation<MatchEntries>> augmentation = new HashMap<Class<? extends Augmentation<MatchEntries>>, Augmentation<MatchEntries>>();

        public Class<MatchEntries> getImplementedInterface() {
            return MatchEntries.class;
        }

        private MatchEntriesImpl(MatchEntriesBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new MatchEntriesKey(builder.isHasMask(), builder.getOxmClass(), builder.getOxmMatchField());
                this._hasMask = builder.isHasMask();
                this._oxmClass = builder.getOxmClass();
                this._oxmMatchField = builder.getOxmMatchField();
            } else {
                this._key = builder.getKey();
                this._hasMask = this._key.isHasMask();
                this._oxmClass = this._key.getOxmClass();
                this._oxmMatchField = this._key.getOxmMatchField();
            }
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Boolean isHasMask() {
            return this._hasMask;
        }

        @Override
        public Class<? extends Clazz> getOxmClass() {
            return this._oxmClass;
        }

        @Override
        public Class<? extends MatchField> getOxmMatchField() {
            return this._oxmMatchField;
        }

        @Override
        public MatchEntriesKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<MatchEntries>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._hasMask == null ? 0 : this._hasMask.hashCode());
            result = 31 * result + (this._oxmClass == null ? 0 : this._oxmClass.hashCode());
            result = 31 * result + (this._oxmMatchField == null ? 0 : this._oxmMatchField.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MatchEntriesImpl other = (MatchEntriesImpl)obj;
            if (this._hasMask == null ? other._hasMask != null : !this._hasMask.equals(other._hasMask)) {
                return false;
            }
            if (this._oxmClass == null ? other._oxmClass != null : !this._oxmClass.equals(other._oxmClass)) {
                return false;
            }
            if (this._oxmMatchField == null ? other._oxmMatchField != null : !this._oxmMatchField.equals(other._oxmMatchField)) {
                return false;
            }
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MatchEntries [_hasMask=");
            builder.append(this._hasMask);
            builder.append(", _oxmClass=");
            builder.append(this._oxmClass);
            builder.append(", _oxmMatchField=");
            builder.append(this._oxmMatchField);
            builder.append(", _key=");
            builder.append(this._key);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

