/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.match.v10.grouping;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowWildcardsV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.match.v10.grouping.MatchV10;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class MatchV10Builder {
    private MacAddress _dlDst;
    private MacAddress _dlSrc;
    private Integer _dlType;
    private Integer _dlVlan;
    private Short _dlVlanPcp;
    private Integer _inPort;
    private Ipv4Address _nwDst;
    private Short _nwDstMask;
    private Short _nwProto;
    private Ipv4Address _nwSrc;
    private Short _nwSrcMask;
    private Short _nwTos;
    private Integer _tpDst;
    private Integer _tpSrc;
    private FlowWildcardsV10 _wildcards;
    private Map<Class<? extends Augmentation<MatchV10>>, Augmentation<MatchV10>> augmentation = new HashMap<Class<? extends Augmentation<MatchV10>>, Augmentation<MatchV10>>();

    public MacAddress getDlDst() {
        return this._dlDst;
    }

    public MacAddress getDlSrc() {
        return this._dlSrc;
    }

    public Integer getDlType() {
        return this._dlType;
    }

    public Integer getDlVlan() {
        return this._dlVlan;
    }

    public Short getDlVlanPcp() {
        return this._dlVlanPcp;
    }

    public Integer getInPort() {
        return this._inPort;
    }

    public Ipv4Address getNwDst() {
        return this._nwDst;
    }

    public Short getNwDstMask() {
        return this._nwDstMask;
    }

    public Short getNwProto() {
        return this._nwProto;
    }

    public Ipv4Address getNwSrc() {
        return this._nwSrc;
    }

    public Short getNwSrcMask() {
        return this._nwSrcMask;
    }

    public Short getNwTos() {
        return this._nwTos;
    }

    public Integer getTpDst() {
        return this._tpDst;
    }

    public Integer getTpSrc() {
        return this._tpSrc;
    }

    public FlowWildcardsV10 getWildcards() {
        return this._wildcards;
    }

    public <E extends Augmentation<MatchV10>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MatchV10Builder setDlDst(MacAddress value) {
        this._dlDst = value;
        return this;
    }

    public MatchV10Builder setDlSrc(MacAddress value) {
        this._dlSrc = value;
        return this;
    }

    public MatchV10Builder setDlType(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._dlType = value;
        return this;
    }

    public MatchV10Builder setDlVlan(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._dlVlan = value;
        return this;
    }

    public MatchV10Builder setDlVlanPcp(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._dlVlanPcp = value;
        return this;
    }

    public MatchV10Builder setInPort(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._inPort = value;
        return this;
    }

    public MatchV10Builder setNwDst(Ipv4Address value) {
        this._nwDst = value;
        return this;
    }

    public MatchV10Builder setNwDstMask(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._nwDstMask = value;
        return this;
    }

    public MatchV10Builder setNwProto(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._nwProto = value;
        return this;
    }

    public MatchV10Builder setNwSrc(Ipv4Address value) {
        this._nwSrc = value;
        return this;
    }

    public MatchV10Builder setNwSrcMask(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._nwSrcMask = value;
        return this;
    }

    public MatchV10Builder setNwTos(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._nwTos = value;
        return this;
    }

    public MatchV10Builder setTpDst(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._tpDst = value;
        return this;
    }

    public MatchV10Builder setTpSrc(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._tpSrc = value;
        return this;
    }

    public MatchV10Builder setWildcards(FlowWildcardsV10 value) {
        this._wildcards = value;
        return this;
    }

    public MatchV10Builder addAugmentation(Class<? extends Augmentation<MatchV10>> augmentationType, Augmentation<MatchV10> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MatchV10 build() {
        return new MatchV10Impl(this);
    }

    private static final class MatchV10Impl
    implements MatchV10 {
        private final MacAddress _dlDst;
        private final MacAddress _dlSrc;
        private final Integer _dlType;
        private final Integer _dlVlan;
        private final Short _dlVlanPcp;
        private final Integer _inPort;
        private final Ipv4Address _nwDst;
        private final Short _nwDstMask;
        private final Short _nwProto;
        private final Ipv4Address _nwSrc;
        private final Short _nwSrcMask;
        private final Short _nwTos;
        private final Integer _tpDst;
        private final Integer _tpSrc;
        private final FlowWildcardsV10 _wildcards;
        private Map<Class<? extends Augmentation<MatchV10>>, Augmentation<MatchV10>> augmentation = new HashMap<Class<? extends Augmentation<MatchV10>>, Augmentation<MatchV10>>();

        public Class<MatchV10> getImplementedInterface() {
            return MatchV10.class;
        }

        private MatchV10Impl(MatchV10Builder builder) {
            this._dlDst = builder.getDlDst();
            this._dlSrc = builder.getDlSrc();
            this._dlType = builder.getDlType();
            this._dlVlan = builder.getDlVlan();
            this._dlVlanPcp = builder.getDlVlanPcp();
            this._inPort = builder.getInPort();
            this._nwDst = builder.getNwDst();
            this._nwDstMask = builder.getNwDstMask();
            this._nwProto = builder.getNwProto();
            this._nwSrc = builder.getNwSrc();
            this._nwSrcMask = builder.getNwSrcMask();
            this._nwTos = builder.getNwTos();
            this._tpDst = builder.getTpDst();
            this._tpSrc = builder.getTpSrc();
            this._wildcards = builder.getWildcards();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public MacAddress getDlDst() {
            return this._dlDst;
        }

        @Override
        public MacAddress getDlSrc() {
            return this._dlSrc;
        }

        @Override
        public Integer getDlType() {
            return this._dlType;
        }

        @Override
        public Integer getDlVlan() {
            return this._dlVlan;
        }

        @Override
        public Short getDlVlanPcp() {
            return this._dlVlanPcp;
        }

        @Override
        public Integer getInPort() {
            return this._inPort;
        }

        @Override
        public Ipv4Address getNwDst() {
            return this._nwDst;
        }

        @Override
        public Short getNwDstMask() {
            return this._nwDstMask;
        }

        @Override
        public Short getNwProto() {
            return this._nwProto;
        }

        @Override
        public Ipv4Address getNwSrc() {
            return this._nwSrc;
        }

        @Override
        public Short getNwSrcMask() {
            return this._nwSrcMask;
        }

        @Override
        public Short getNwTos() {
            return this._nwTos;
        }

        @Override
        public Integer getTpDst() {
            return this._tpDst;
        }

        @Override
        public Integer getTpSrc() {
            return this._tpSrc;
        }

        @Override
        public FlowWildcardsV10 getWildcards() {
            return this._wildcards;
        }

        public <E extends Augmentation<MatchV10>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._dlDst == null ? 0 : this._dlDst.hashCode());
            result = 31 * result + (this._dlSrc == null ? 0 : this._dlSrc.hashCode());
            result = 31 * result + (this._dlType == null ? 0 : this._dlType.hashCode());
            result = 31 * result + (this._dlVlan == null ? 0 : this._dlVlan.hashCode());
            result = 31 * result + (this._dlVlanPcp == null ? 0 : this._dlVlanPcp.hashCode());
            result = 31 * result + (this._inPort == null ? 0 : this._inPort.hashCode());
            result = 31 * result + (this._nwDst == null ? 0 : this._nwDst.hashCode());
            result = 31 * result + (this._nwDstMask == null ? 0 : this._nwDstMask.hashCode());
            result = 31 * result + (this._nwProto == null ? 0 : this._nwProto.hashCode());
            result = 31 * result + (this._nwSrc == null ? 0 : this._nwSrc.hashCode());
            result = 31 * result + (this._nwSrcMask == null ? 0 : this._nwSrcMask.hashCode());
            result = 31 * result + (this._nwTos == null ? 0 : this._nwTos.hashCode());
            result = 31 * result + (this._tpDst == null ? 0 : this._tpDst.hashCode());
            result = 31 * result + (this._tpSrc == null ? 0 : this._tpSrc.hashCode());
            result = 31 * result + (this._wildcards == null ? 0 : this._wildcards.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MatchV10Impl other = (MatchV10Impl)obj;
            if (this._dlDst == null ? other._dlDst != null : !this._dlDst.equals((Object)other._dlDst)) {
                return false;
            }
            if (this._dlSrc == null ? other._dlSrc != null : !this._dlSrc.equals((Object)other._dlSrc)) {
                return false;
            }
            if (this._dlType == null ? other._dlType != null : !this._dlType.equals(other._dlType)) {
                return false;
            }
            if (this._dlVlan == null ? other._dlVlan != null : !this._dlVlan.equals(other._dlVlan)) {
                return false;
            }
            if (this._dlVlanPcp == null ? other._dlVlanPcp != null : !this._dlVlanPcp.equals(other._dlVlanPcp)) {
                return false;
            }
            if (this._inPort == null ? other._inPort != null : !this._inPort.equals(other._inPort)) {
                return false;
            }
            if (this._nwDst == null ? other._nwDst != null : !this._nwDst.equals((Object)other._nwDst)) {
                return false;
            }
            if (this._nwDstMask == null ? other._nwDstMask != null : !this._nwDstMask.equals(other._nwDstMask)) {
                return false;
            }
            if (this._nwProto == null ? other._nwProto != null : !this._nwProto.equals(other._nwProto)) {
                return false;
            }
            if (this._nwSrc == null ? other._nwSrc != null : !this._nwSrc.equals((Object)other._nwSrc)) {
                return false;
            }
            if (this._nwSrcMask == null ? other._nwSrcMask != null : !this._nwSrcMask.equals(other._nwSrcMask)) {
                return false;
            }
            if (this._nwTos == null ? other._nwTos != null : !this._nwTos.equals(other._nwTos)) {
                return false;
            }
            if (this._tpDst == null ? other._tpDst != null : !this._tpDst.equals(other._tpDst)) {
                return false;
            }
            if (this._tpSrc == null ? other._tpSrc != null : !this._tpSrc.equals(other._tpSrc)) {
                return false;
            }
            if (this._wildcards == null ? other._wildcards != null : !this._wildcards.equals(other._wildcards)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MatchV10 [_dlDst=");
            builder.append(this._dlDst);
            builder.append(", _dlSrc=");
            builder.append(this._dlSrc);
            builder.append(", _dlType=");
            builder.append(this._dlType);
            builder.append(", _dlVlan=");
            builder.append(this._dlVlan);
            builder.append(", _dlVlanPcp=");
            builder.append(this._dlVlanPcp);
            builder.append(", _inPort=");
            builder.append(this._inPort);
            builder.append(", _nwDst=");
            builder.append(this._nwDst);
            builder.append(", _nwDstMask=");
            builder.append(this._nwDstMask);
            builder.append(", _nwProto=");
            builder.append(this._nwProto);
            builder.append(", _nwSrc=");
            builder.append(this._nwSrc);
            builder.append(", _nwSrcMask=");
            builder.append(this._nwSrcMask);
            builder.append(", _nwTos=");
            builder.append(this._nwTos);
            builder.append(", _tpDst=");
            builder.append(this._tpDst);
            builder.append(", _tpSrc=");
            builder.append(this._tpSrc);
            builder.append(", _wildcards=");
            builder.append(this._wildcards);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

