/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.Instructions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.InstructionsKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.Instruction;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class InstructionsBuilder {
    private Class<? extends Instruction> _type;
    private InstructionsKey _key;
    private Map<Class<? extends Augmentation<Instructions>>, Augmentation<Instructions>> augmentation = new HashMap<Class<? extends Augmentation<Instructions>>, Augmentation<Instructions>>();

    public Class<? extends Instruction> getType() {
        return this._type;
    }

    public InstructionsKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<Instructions>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public InstructionsBuilder setType(Class<? extends Instruction> value) {
        this._type = value;
        return this;
    }

    public InstructionsBuilder setKey(InstructionsKey value) {
        this._key = value;
        return this;
    }

    public InstructionsBuilder addAugmentation(Class<? extends Augmentation<Instructions>> augmentationType, Augmentation<Instructions> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Instructions build() {
        return new InstructionsImpl(this);
    }

    private static final class InstructionsImpl
    implements Instructions {
        private final Class<? extends Instruction> _type;
        private final InstructionsKey _key;
        private Map<Class<? extends Augmentation<Instructions>>, Augmentation<Instructions>> augmentation = new HashMap<Class<? extends Augmentation<Instructions>>, Augmentation<Instructions>>();

        public Class<Instructions> getImplementedInterface() {
            return Instructions.class;
        }

        private InstructionsImpl(InstructionsBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new InstructionsKey(builder.getType());
                this._type = builder.getType();
            } else {
                this._key = builder.getKey();
                this._type = this._key.getType();
            }
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Class<? extends Instruction> getType() {
            return this._type;
        }

        @Override
        public InstructionsKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<Instructions>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._type == null ? 0 : this._type.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InstructionsImpl other = (InstructionsImpl)obj;
            if (this._type == null ? other._type != null : !this._type.equals(other._type)) {
                return false;
            }
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Instructions [_type=");
            builder.append(this._type);
            builder.append(", _key=");
            builder.append(this._key);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

