/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions.ActionsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions.ActionsListKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions.actions.list.Action;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class ActionsListBuilder {
    private Action _action;
    private ActionsListKey _key;
    private Map<Class<? extends Augmentation<ActionsList>>, Augmentation<ActionsList>> augmentation = new HashMap<Class<? extends Augmentation<ActionsList>>, Augmentation<ActionsList>>();

    public Action getAction() {
        return this._action;
    }

    public ActionsListKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<ActionsList>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ActionsListBuilder setAction(Action value) {
        this._action = value;
        return this;
    }

    public ActionsListBuilder setKey(ActionsListKey value) {
        this._key = value;
        return this;
    }

    public ActionsListBuilder addAugmentation(Class<? extends Augmentation<ActionsList>> augmentationType, Augmentation<ActionsList> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ActionsList build() {
        return new ActionsListImpl(this);
    }

    private static final class ActionsListImpl
    implements ActionsList {
        private final Action _action;
        private final ActionsListKey _key;
        private Map<Class<? extends Augmentation<ActionsList>>, Augmentation<ActionsList>> augmentation = new HashMap<Class<? extends Augmentation<ActionsList>>, Augmentation<ActionsList>>();

        public Class<ActionsList> getImplementedInterface() {
            return ActionsList.class;
        }

        private ActionsListImpl(ActionsListBuilder builder) {
            this._key = builder.getKey() == null ? new ActionsListKey() : builder.getKey();
            this._action = builder.getAction();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Action getAction() {
            return this._action;
        }

        @Override
        public ActionsListKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<ActionsList>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._action == null ? 0 : this._action.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ActionsListImpl other = (ActionsListImpl)obj;
            if (this._action == null ? other._action != null : !this._action.equals(other._action)) {
                return false;
            }
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ActionsList [_action=");
            builder.append(this._action);
            builder.append(", _key=");
            builder.append(this._key);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

