/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002;

import com.google.common.collect.Range;
import java.util.ArrayList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.VlanVidMatchEntry;

public class VlanVidMatchEntryBuilder {
    private Boolean _cfiBit;
    private Integer _vlanVid;

    public Boolean isCfiBit() {
        return this._cfiBit;
    }

    public Integer getVlanVid() {
        return this._vlanVid;
    }

    public VlanVidMatchEntryBuilder setCfiBit(Boolean value) {
        this._cfiBit = value;
        return this;
    }

    public VlanVidMatchEntryBuilder setVlanVid(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._vlanVid = value;
        return this;
    }

    public VlanVidMatchEntry build() {
        return new VlanVidMatchEntryImpl(this);
    }

    private static final class VlanVidMatchEntryImpl
    implements VlanVidMatchEntry {
        private final Boolean _cfiBit;
        private final Integer _vlanVid;

        public Class<VlanVidMatchEntry> getImplementedInterface() {
            return VlanVidMatchEntry.class;
        }

        private VlanVidMatchEntryImpl(VlanVidMatchEntryBuilder builder) {
            this._cfiBit = builder.isCfiBit();
            this._vlanVid = builder.getVlanVid();
        }

        @Override
        public Boolean isCfiBit() {
            return this._cfiBit;
        }

        @Override
        public Integer getVlanVid() {
            return this._vlanVid;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._cfiBit == null ? 0 : this._cfiBit.hashCode());
            result = 31 * result + (this._vlanVid == null ? 0 : this._vlanVid.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VlanVidMatchEntryImpl other = (VlanVidMatchEntryImpl)obj;
            if (this._cfiBit == null ? other._cfiBit != null : !this._cfiBit.equals(other._cfiBit)) {
                return false;
            }
            return !(this._vlanVid == null ? other._vlanVid != null : !this._vlanVid.equals(other._vlanVid));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("VlanVidMatchEntry [_cfiBit=");
            builder.append(this._cfiBit);
            builder.append(", _vlanVid=");
            builder.append(this._vlanVid);
            builder.append("]");
            return builder.toString();
        }
    }
}

