/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002;

import com.google.common.collect.Range;
import java.util.ArrayList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.VlanVidAction;

public class VlanVidActionBuilder {
    private Integer _vlanVid;

    public Integer getVlanVid() {
        return this._vlanVid;
    }

    public VlanVidActionBuilder setVlanVid(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._vlanVid = value;
        return this;
    }

    public VlanVidAction build() {
        return new VlanVidActionImpl(this);
    }

    private static final class VlanVidActionImpl
    implements VlanVidAction {
        private final Integer _vlanVid;

        public Class<VlanVidAction> getImplementedInterface() {
            return VlanVidAction.class;
        }

        private VlanVidActionImpl(VlanVidActionBuilder builder) {
            this._vlanVid = builder.getVlanVid();
        }

        @Override
        public Integer getVlanVid() {
            return this._vlanVid;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._vlanVid == null ? 0 : this._vlanVid.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VlanVidActionImpl other = (VlanVidActionImpl)obj;
            return !(this._vlanVid == null ? other._vlanVid != null : !this._vlanVid.equals(other._vlanVid));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("VlanVidAction [_vlanVid=");
            builder.append(this._vlanVid);
            builder.append("]");
            return builder.toString();
        }
    }
}

