/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002;

import com.google.common.collect.Range;
import java.util.ArrayList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.VlanPcpMatchEntry;

public class VlanPcpMatchEntryBuilder {
    private Short _vlanPcp;

    public Short getVlanPcp() {
        return this._vlanPcp;
    }

    public VlanPcpMatchEntryBuilder setVlanPcp(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._vlanPcp = value;
        return this;
    }

    public VlanPcpMatchEntry build() {
        return new VlanPcpMatchEntryImpl(this);
    }

    private static final class VlanPcpMatchEntryImpl
    implements VlanPcpMatchEntry {
        private final Short _vlanPcp;

        public Class<VlanPcpMatchEntry> getImplementedInterface() {
            return VlanPcpMatchEntry.class;
        }

        private VlanPcpMatchEntryImpl(VlanPcpMatchEntryBuilder builder) {
            this._vlanPcp = builder.getVlanPcp();
        }

        @Override
        public Short getVlanPcp() {
            return this._vlanPcp;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._vlanPcp == null ? 0 : this._vlanPcp.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VlanPcpMatchEntryImpl other = (VlanPcpMatchEntryImpl)obj;
            return !(this._vlanPcp == null ? other._vlanPcp != null : !this._vlanPcp.equals(other._vlanPcp));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("VlanPcpMatchEntry [_vlanPcp=");
            builder.append(this._vlanPcp);
            builder.append("]");
            return builder.toString();
        }
    }
}

