/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002;

import com.google.common.collect.Range;
import java.util.ArrayList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.VlanPcpAction;

public class VlanPcpActionBuilder {
    private Short _vlanPcp;

    public Short getVlanPcp() {
        return this._vlanPcp;
    }

    public VlanPcpActionBuilder setVlanPcp(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._vlanPcp = value;
        return this;
    }

    public VlanPcpAction build() {
        return new VlanPcpActionImpl(this);
    }

    private static final class VlanPcpActionImpl
    implements VlanPcpAction {
        private final Short _vlanPcp;

        public Class<VlanPcpAction> getImplementedInterface() {
            return VlanPcpAction.class;
        }

        private VlanPcpActionImpl(VlanPcpActionBuilder builder) {
            this._vlanPcp = builder.getVlanPcp();
        }

        @Override
        public Short getVlanPcp() {
            return this._vlanPcp;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._vlanPcp == null ? 0 : this._vlanPcp.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VlanPcpActionImpl other = (VlanPcpActionImpl)obj;
            return !(this._vlanPcp == null ? other._vlanPcp != null : !this._vlanPcp.equals(other._vlanPcp));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("VlanPcpAction [_vlanPcp=");
            builder.append(this._vlanPcp);
            builder.append("]");
            return builder.toString();
        }
    }
}

