/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002;

import com.google.common.collect.Range;
import java.util.ArrayList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.TableIdInstruction;

public class TableIdInstructionBuilder {
    private Short _tableId;

    public Short getTableId() {
        return this._tableId;
    }

    public TableIdInstructionBuilder setTableId(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._tableId = value;
        return this;
    }

    public TableIdInstruction build() {
        return new TableIdInstructionImpl(this);
    }

    private static final class TableIdInstructionImpl
    implements TableIdInstruction {
        private final Short _tableId;

        public Class<TableIdInstruction> getImplementedInterface() {
            return TableIdInstruction.class;
        }

        private TableIdInstructionImpl(TableIdInstructionBuilder builder) {
            this._tableId = builder.getTableId();
        }

        @Override
        public Short getTableId() {
            return this._tableId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._tableId == null ? 0 : this._tableId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TableIdInstructionImpl other = (TableIdInstructionImpl)obj;
            return !(this._tableId == null ? other._tableId != null : !this._tableId.equals(other._tableId));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("TableIdInstruction [_tableId=");
            builder.append(this._tableId);
            builder.append("]");
            return builder.toString();
        }
    }
}

